/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud.server.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.bean.CloudData;
import top.hserver.cloud.bean.InvokeServiceData;
import top.hserver.cloud.bean.ResultData;
import top.hserver.cloud.bean.ServiceData;
import top.hserver.cloud.common.Msg;
import top.hserver.cloud.future.SyncWrite;
import top.hserver.cloud.future.SyncWriteFuture;
import top.hserver.cloud.future.SyncWriteMap;

public class ServerHandler
extends SimpleChannelInboundHandler<Msg> {
    private static final Logger log = LoggerFactory.getLogger(ServerHandler.class);
    private static final Map<String, ServiceData> classStringMap = new ConcurrentHashMap<String, ServiceData>();

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Msg msg) throws Exception {
        switch (msg.getMsg_type()) {
            case REG: {
                CloudData data = (CloudData)msg.getData();
                ServiceData serviceData = new ServiceData();
                serviceData.setIp(data.getIp());
                serviceData.setName(data.getName());
                serviceData.setCtx(channelHandlerContext);
                data.getClasses().forEach(a -> classStringMap.put((String)a, serviceData));
                log.info(data.toString());
                break;
            }
            case RESULT: {
                ResultData resultData = (ResultData)msg.getData();
                String requestId = resultData.getUUID();
                SyncWriteFuture future = (SyncWriteFuture)SyncWriteMap.syncKey.get(requestId);
                if (future == null) break;
                future.setResultData(resultData);
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }

    public static Object SendInvoker(InvokeServiceData invokeServiceData) throws Exception {
        ServiceData serviceData = classStringMap.get(invokeServiceData.getAClass());
        if (serviceData != null) {
            ChannelHandlerContext ctx = serviceData.getCtx();
            if (ctx != null && ctx.channel().isActive()) {
                ResultData response = new SyncWrite().writeAndSync(ctx, invokeServiceData, 5000L);
                switch (response.getCode()) {
                    case 200: {
                        return response.getData();
                    }
                    case 404: {
                        return new NullPointerException("\u6682\u65e0\u670d\u52a1");
                    }
                }
                return new NullPointerException("\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38");
            }
            return new NullPointerException("\u6682\u65e0\u670d\u52a1");
        }
        return new NullPointerException("\u6682\u65e0\u670d\u52a1");
    }
}

