/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud.task;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.CloudManager;
import top.hserver.cloud.bean.CloudData;
import top.hserver.cloud.client.ChatClient;
import top.hserver.cloud.client.RegClient;
import top.hserver.cloud.common.MSG_TYPE;
import top.hserver.cloud.common.Msg;
import top.hserver.cloud.util.NetUtil;
import top.hserver.core.interfaces.TaskJob;

public class BroadcastTask
implements TaskJob {
    private static final Logger log = LoggerFactory.getLogger(BroadcastTask.class);

    @Override
    public void exec(Object ... args) {
        if (CloudManager.isRpcService()) {
            if (ChatClient.channel != null && ChatClient.channel.isActive()) {
                CloudData cloudData = new CloudData();
                cloudData.setIp(NetUtil.getIpAddress());
                cloudData.setName("ServerA");
                cloudData.setClasses(CloudManager.getClasses());
                Msg<CloudData> msg = new Msg<CloudData>();
                msg.setMsg_type(MSG_TYPE.REG);
                msg.setData(cloudData);
                ChatClient.channel.writeAndFlush(msg);
            } else {
                log.warn("\u8fde\u63a5\u88ab\u65ad\u5f00\u3002\u6b63\u5728\u91cd\u65b0\u8fde\u63a5\u3002\u3002\u3002\u3002");
                if (ChatClient.channel != null) {
                    ChatClient.channel.close();
                }
                new RegClient().start();
            }
        }
    }
}

