/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.ioc.ref;

import io.netty.handler.codec.http.HttpMethod;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.CloudManager;
import top.hserver.cloud.bean.ClientData;
import top.hserver.cloud.proxy.CloudProxy;
import top.hserver.core.interfaces.FilterAdapter;
import top.hserver.core.interfaces.GlobalException;
import top.hserver.core.interfaces.InitRunner;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.ioc.annotation.Autowired;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.ioc.annotation.Configuration;
import top.hserver.core.ioc.annotation.Filter;
import top.hserver.core.ioc.annotation.GET;
import top.hserver.core.ioc.annotation.Hook;
import top.hserver.core.ioc.annotation.POST;
import top.hserver.core.ioc.annotation.Resource;
import top.hserver.core.ioc.annotation.RpcService;
import top.hserver.core.ioc.annotation.Task;
import top.hserver.core.ioc.annotation.WebSocket;
import top.hserver.core.ioc.ref.ClasspathPackageScanner;
import top.hserver.core.ioc.ref.PackageScanner;
import top.hserver.core.proxy.JavassistProxyFactory;
import top.hserver.core.server.filter.FilterChain;
import top.hserver.core.server.handlers.WebSocketServerHandler;
import top.hserver.core.server.router.RouterInfo;
import top.hserver.core.server.router.RouterManager;
import top.hserver.core.server.util.ParameterUtil;
import top.hserver.core.task.TaskManager;

public class InitBean {
    private static final Logger log = LoggerFactory.getLogger(InitBean.class);

    public static void init(Class<?> baseClass) {
        try {
            if (baseClass == null || baseClass.getPackage() == null || baseClass.getPackage().getName() == null) {
                return;
            }
            ClasspathPackageScanner scan = new ClasspathPackageScanner(baseClass.getPackage().getName());
            InitBean.initConfiguration(scan);
            InitBean.initWebSocket(scan);
            InitBean.initBean(scan);
            InitBean.initController(scan);
            InitBean.initHook(scan);
            InitBean.initFilter(scan);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initConfiguration(PackageScanner scan) throws Exception {
        List<Class<?>> classs = scan.getConfigurationPackage();
        for (Class<?> aClass : classs) {
            Configuration annotation = aClass.getAnnotation(Configuration.class);
            if (annotation == null) continue;
            Method[] methods = aClass.getDeclaredMethods();
            Object o = aClass.newInstance();
            for (Method method : methods) {
                Bean bean = method.getAnnotation(Bean.class);
                if (bean == null) continue;
                Object invoke = method.invoke(o, new Object[0]);
                String value = bean.value();
                if (value.trim().length() > 0) {
                    IocUtil.addBean(value, invoke);
                    continue;
                }
                IocUtil.addBean(invoke.getClass().getName(), invoke);
            }
        }
    }

    private static void initWebSocket(PackageScanner scan) throws Exception {
        List<Class<?>> classs = scan.getWebSocketPackage();
        for (Class<?> aClass : classs) {
            WebSocket annotation = aClass.getAnnotation(WebSocket.class);
            if (annotation == null) continue;
            IocUtil.addBean(aClass.getName(), aClass.newInstance());
            WebSocketServerHandler.WebSocketRouter.put(annotation.value(), aClass.getName());
        }
    }

    private static void initBean(PackageScanner scan) throws Exception {
        List<Class<?>> classs = scan.getBeansPackage();
        for (Class<?> aClass : classs) {
            if (GlobalException.class.isAssignableFrom(aClass)) {
                IocUtil.addBean(GlobalException.class.getName(), aClass.newInstance());
                continue;
            }
            if (InitRunner.class.isAssignableFrom(aClass)) {
                IocUtil.addBean(InitRunner.class.getName(), aClass.newInstance());
                continue;
            }
            Bean annotation = aClass.getAnnotation(Bean.class);
            if (annotation.value().trim().length() > 0) {
                IocUtil.addBean(annotation.value(), aClass.newInstance());
            } else {
                IocUtil.addBean(aClass.getName(), aClass.newInstance());
            }
            Method[] methods = aClass.getDeclaredMethods();
            RpcService rpcService = aClass.getAnnotation(RpcService.class);
            if (rpcService != null) {
                ClientData clientData = new ClientData();
                clientData.setClassName(aClass.getName());
                clientData.setMethods(methods);
                if (rpcService.value().trim().length() > 0) {
                    clientData.setAClass(rpcService.value());
                    CloudManager.add(rpcService.value(), clientData);
                    IocUtil.addBean(rpcService.value(), aClass.newInstance());
                } else {
                    Class<?>[] interfaces = aClass.getInterfaces();
                    if (interfaces != null && interfaces.length > 0) {
                        clientData.setAClass(interfaces[0].getName());
                        IocUtil.addBean(interfaces[0].getName(), aClass.newInstance());
                        CloudManager.add(interfaces[0].getName(), clientData);
                    } else {
                        log.error("RPC\u6ca1\u6709\u5b9e\u73b0\u4efb\u4f55\u63a5\u53e3\uff0c\u9884\u8ba1\u8c03\u7528\u8fc7\u7a0b\u4f1a\u51fa\u73b0\u95ee\u9898:" + aClass.getSimpleName());
                    }
                }
            }
            for (Method method : methods) {
                Task task = method.getAnnotation(Task.class);
                if (task == null) continue;
                if (annotation.value().trim().length() > 0) {
                    TaskManager.initTask(task.name(), task.time(), annotation.value(), method, new Object[0]);
                    continue;
                }
                TaskManager.initTask(task.name(), task.time(), aClass.getName(), method, new Object[0]);
            }
        }
    }

    private static void initController(PackageScanner scan) throws Exception {
        List<Class<?>> classs = scan.getControllersPackage();
        for (Class<?> aClass : classs) {
            Method[] methods;
            for (Method method : methods = aClass.getDeclaredMethods()) {
                RouterInfo routerInfo;
                ParameterUtil.addParam(aClass, method);
                GET get = method.getAnnotation(GET.class);
                POST post = method.getAnnotation(POST.class);
                if (get != null) {
                    routerInfo = new RouterInfo();
                    routerInfo.setMethod(method);
                    routerInfo.setUrl(get.value());
                    routerInfo.setaClass(aClass);
                    routerInfo.setReqMethodName(HttpMethod.GET);
                    RouterManager.addRouter(routerInfo);
                }
                if (post == null) continue;
                routerInfo = new RouterInfo();
                routerInfo.setMethod(method);
                routerInfo.setUrl(post.value());
                routerInfo.setaClass(aClass);
                routerInfo.setReqMethodName(HttpMethod.POST);
                RouterManager.addRouter(routerInfo);
            }
            IocUtil.addBean(aClass.getName(), aClass.newInstance());
        }
    }

    private static void initFilter(PackageScanner scan) throws Exception {
        List<Class<?>> classes = scan.getFiltersPackage();
        HashMap map = new HashMap();
        int tempMax = 0;
        for (Class<?> clazz : classes) {
            Filter handlerAnno = clazz.getAnnotation(Filter.class);
            if (handlerAnno == null) continue;
            log.info(clazz.getCanonicalName() + "\u4f18\u5148\u7ea7\uff1a" + handlerAnno.value());
            FilterAdapter obj = null;
            try {
                obj = (FilterAdapter)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316 " + clazz.getSimpleName() + " \u9519\u8bef", (Throwable)e);
                continue;
            }
            if (obj == null) continue;
            if (map.containsKey(handlerAnno.value())) {
                throw new RuntimeException("\u521d\u59cb\u5316\u63d2\u4ef6\u51fa\u73b0\u5f02\u5e38\uff0c\u987a\u5e8f\u51b2\u7a81:" + handlerAnno.value());
            }
            HashMap<String, FilterAdapter> filterMap = new HashMap<String, FilterAdapter>();
            filterMap.put(clazz.getName(), obj);
            map.put(handlerAnno.value(), filterMap);
            if (handlerAnno.value() <= tempMax) continue;
            tempMax = handlerAnno.value();
        }
        for (int i = 0; i <= tempMax; ++i) {
            if (!map.containsKey(i)) continue;
            Map filterMap = (Map)map.get(i);
            FilterChain.filtersIoc.add(filterMap);
        }
    }

    private static void initHook(PackageScanner scan) throws Exception {
        JavassistProxyFactory javassistProxyFactory = new JavassistProxyFactory();
        List<Class<?>> classs = scan.getHooksPackage();
        for (Class<?> aClass : classs) {
            Hook hook = aClass.getAnnotation(Hook.class);
            Class value = hook.value();
            String method = hook.method();
            Object newProxyInstance = javassistProxyFactory.newProxyInstance(value, aClass.getName(), method);
            IocUtil.addBean(aClass.getName(), aClass.newInstance());
            IocUtil.addBean(value.getName(), newProxyInstance);
        }
    }

    public static void injection() {
        Map<String, Object> all = IocUtil.getAll();
        all.forEach((k, v) -> {
            Field[] declaredFields1;
            Field[] declaredFields;
            for (Field declaredField : declaredFields = v.getClass().getDeclaredFields()) {
                InitBean.zr(declaredField, v);
                InitBean.rpczr(declaredField, v);
            }
            for (Field field : declaredFields1 = v.getClass().getSuperclass().getDeclaredFields()) {
                InitBean.zr(field, v);
                InitBean.rpczr(field, v);
            }
        });
        List<Map<String, FilterAdapter>> filtersIoc = FilterChain.filtersIoc;
        filtersIoc.forEach(v -> {
            Field[] declaredFields1;
            Field[] declaredFields;
            String next = (String)v.keySet().iterator().next();
            FilterAdapter filterAdapter = (FilterAdapter)v.get(next);
            for (Field declaredField : declaredFields = filterAdapter.getClass().getDeclaredFields()) {
                InitBean.zr(declaredField, filterAdapter);
                InitBean.rpczr(declaredField, filterAdapter);
            }
            for (Field field : declaredFields1 = filterAdapter.getClass().getSuperclass().getDeclaredFields()) {
                InitBean.zr(field, filterAdapter);
                InitBean.rpczr(field, filterAdapter);
            }
        });
    }

    private static void rpczr(Field declaredField, Object v) {
        Resource annotation = declaredField.getAnnotation(Resource.class);
        if (annotation != null) {
            try {
                declaredField.setAccessible(true);
                Object proxy = CloudProxy.getProxy(declaredField.getType(), annotation);
                declaredField.set(v, proxy);
                log.info(proxy.getClass().getSimpleName() + "----->" + v.getClass().getSimpleName() + "\uff1a\u88c5\u914d\u5b8c\u6210\uff0cRpc\u88c5\u914d");
            }
            catch (Exception e) {
                log.error(v.getClass().getSimpleName() + "----->" + v.getClass().getSimpleName() + "\uff1a\u88c5\u914d\u9519\u8bef:RPC\u4ee3\u7406\u751f\u6210\u5931\u8d25");
            }
        }
    }

    private static void zr(Field declaredField, Object v) {
        Autowired annotation = declaredField.getAnnotation(Autowired.class);
        if (annotation != null) {
            String findMsg;
            Object bean;
            declaredField.setAccessible(true);
            if (annotation.value().trim().length() > 0) {
                bean = IocUtil.getBean(annotation.value());
                findMsg = "\u6309\u81ea\u5b9a\u4e49\u540d\u5b57\u88c5\u914d\uff0c" + declaredField.getType().getSimpleName();
            } else {
                findMsg = "\u6309\u7c7b\u578b\u88c5\u914d\uff0c" + declaredField.getType().getSimpleName();
                bean = IocUtil.getBean(declaredField.getType());
            }
            if (bean == null) {
                Map<String, Object> all = IocUtil.getAll();
                ArrayList allClassByInterface = new ArrayList();
                all.forEach((a, b) -> {
                    if (declaredField.getType().isAssignableFrom(b.getClass())) {
                        allClassByInterface.add(b.getClass());
                    }
                });
                if (allClassByInterface.size() > 0) {
                    if (allClassByInterface.size() > 1) {
                        log.warn("\u88c5\u914d\u8b66\u544a\uff0c\u5b58\u5728\u591a\u4e2a\u5b50\u7c7b\uff0c\u5efa\u8bae\u901a\u8fc7Bean\u540d\u5b57\u88c5\u914d\uff0c\u907f\u514d\u88c5\u914d\u9519\u8bef");
                    }
                    bean = IocUtil.getBean((Class)allClassByInterface.get(0));
                    findMsg = "\u6309\u5b50\u7c7b\u88c5\u914d\uff0c" + declaredField.getType().getSimpleName();
                } else {
                    log.error("\u88c5\u914d\u9519\u8bef:\u5bb9\u5668\u4e2d\u672a\u627e\u5230\u5bf9\u5e94\u7684Bean\u5bf9\u8c61\u88c5\u5907\u914d,\u67e5\u627e\u8bf4\u660e\uff1a" + findMsg);
                    return;
                }
            }
            try {
                if (bean.getClass().getName().contains(declaredField.getType().getName())) {
                    declaredField.set(v, bean);
                    log.info(bean.getClass().getSimpleName() + "----->" + v.getClass().getSimpleName() + "\uff1a\u88c5\u914d\u5b8c\u6210\uff0c" + findMsg);
                } else if (declaredField.getType().isAssignableFrom(bean.getClass())) {
                    declaredField.set(v, bean);
                    log.info(bean.getClass().getSimpleName() + "----->" + v.getClass().getSimpleName() + "\uff1a\u88c5\u914d\u5b8c\u6210\uff0c" + findMsg);
                } else {
                    log.error(v.getClass().getSimpleName() + "----->" + v.getClass().getSimpleName() + "\uff1a\u88c5\u914d\u9519\u8bef:\u7c7b\u578b\u4e0d\u5339\u914d");
                }
            }
            catch (Exception e) {
                log.error("\u88c5\u914d\u9519\u8bef:" + e.getMessage());
            }
        }
    }
}

