/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.context;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import top.hserver.core.interfaces.HttpRequest;
import top.hserver.core.server.handlers.FileItem;

public class Request
implements HttpRequest {
    private String uri;
    private HttpMethod requestType;
    private String ip;
    private Map<String, String> requestParams = new ConcurrentHashMap<String, String>();
    private Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private static final ByteBuf EMPTY_BUF = Unpooled.copiedBuffer((CharSequence)"", (Charset)CharsetUtil.UTF_8);
    private ByteBuf body = EMPTY_BUF;
    private Map<String, FileItem> fileItems = new HashMap<String, FileItem>(8);
    private HttpData partialContent;

    public ByteBuf getBody() {
        return this.body;
    }

    public void setBody(ByteBuf body) {
        this.body = body;
    }

    @Override
    public String query(String name) {
        return this.requestParams.get(name);
    }

    @Override
    public FileItem queryFile(String name) {
        return this.fileItems.get(name);
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public String getHeader(String headName) {
        return this.headers.get(headName);
    }

    public void readHttpDataChunkByChunk(HttpPostRequestDecoder decoder) {
        try {
            InterfaceHttpData data;
            while (decoder.hasNext()) {
                data = decoder.next();
                if (data == null) continue;
                if (this.partialContent == data) {
                    this.partialContent = null;
                }
                try {
                    this.writeHttpData(data);
                }
                finally {
                    data.release();
                }
            }
            data = decoder.currentPartialHttpData();
            if (data != null && this.partialContent == null) {
                this.partialContent = (HttpData)data;
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException endOfDataDecoderException) {
            // empty catch block
        }
    }

    private void writeHttpData(InterfaceHttpData data) {
        try {
            InterfaceHttpData.HttpDataType dataType = data.getHttpDataType();
            if (dataType == InterfaceHttpData.HttpDataType.Attribute) {
                this.parseAttribute((Attribute)data);
            } else if (dataType == InterfaceHttpData.HttpDataType.FileUpload) {
                this.parseFileUpload((FileUpload)data);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseAttribute(Attribute attribute) throws IOException {
        this.requestParams.put(attribute.getName(), attribute.getValue());
    }

    private void parseFileUpload(FileUpload fileUpload) throws IOException {
        if (!fileUpload.isCompleted()) {
            return;
        }
        FileItem fileItem = new FileItem();
        fileItem.setName(fileUpload.getName());
        fileItem.setFileName(fileUpload.getFilename());
        Path tmpFile = Files.createTempFile(Paths.get(fileUpload.getFile().getParent(), new String[0]), "h_server_", "_upload", new FileAttribute[0]);
        Path fileUploadPath = Paths.get(fileUpload.getFile().getPath(), new String[0]);
        Files.move(fileUploadPath, tmpFile, StandardCopyOption.REPLACE_EXISTING);
        fileItem.setFile(tmpFile.toFile());
        fileItem.setPath(tmpFile.toFile().getPath());
        fileItem.setContentType(fileUpload.getContentType());
        fileItem.setLength(fileUpload.length());
        this.fileItems.put(fileItem.getName(), fileItem);
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public HttpMethod getRequestType() {
        return this.requestType;
    }

    @Override
    public Map<String, String> getRequestParams() {
        return this.requestParams;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Map<String, FileItem> getFileItems() {
        return this.fileItems;
    }

    public HttpData getPartialContent() {
        return this.partialContent;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setRequestType(HttpMethod requestType) {
        this.requestType = requestType;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setRequestParams(Map<String, String> requestParams) {
        this.requestParams = requestParams;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setFileItems(Map<String, FileItem> fileItems) {
        this.fileItems = fileItems;
    }

    public void setPartialContent(HttpData partialContent) {
        this.partialContent = partialContent;
    }
}

