/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.GlobalException;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.Request;
import top.hserver.core.server.context.Response;
import top.hserver.core.server.context.StaticFile;
import top.hserver.core.server.context.WebContext;
import top.hserver.core.server.context.Webkit;
import top.hserver.core.server.exception.BusinessException;
import top.hserver.core.server.filter.FilterChain;
import top.hserver.core.server.handlers.StaticHandler;
import top.hserver.core.server.handlers.StatisticsHandler;
import top.hserver.core.server.router.RouterInfo;
import top.hserver.core.server.router.RouterManager;
import top.hserver.core.server.util.DownLoadUtil;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.ParameterUtil;

public class DispatcherHandler {
    private static final Logger log = LoggerFactory.getLogger(DispatcherHandler.class);
    private static final StatisticsHandler statisticsHandler = new StatisticsHandler();
    private static final StaticHandler staticHandler = new StaticHandler();
    private static final HttpDataFactory HTTP_DATA_FACTORY = new DefaultHttpDataFactory(true);
    private static final CopyOnWriteArraySet<String> noStaticFileUri = new CopyOnWriteArraySet();

    public static WebContext buildWebContext(ChannelHandlerContext ctx, WebContext webContext) {
        int i;
        HttpRequest req = webContext.getHttpRequest();
        Request request = new Request();
        request.setIp(statisticsHandler.getClientIp(ctx));
        webContext.setCtx(ctx);
        if (req.method() == HttpMethod.GET) {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
            Map parame = decoder.parameters();
            for (Map.Entry next : parame.entrySet()) {
                requestParams.put((String)next.getKey(), (String)((List)next.getValue()).get(0));
            }
            request.setRequestParams(requestParams);
        }
        if (req.method() == HttpMethod.POST) {
            try {
                HttpPostRequestDecoder decoder = new HttpPostRequestDecoder(HTTP_DATA_FACTORY, req);
                boolean isMultipart = decoder.isMultipart();
                ArrayList<ByteBuf> byteBuffs = new ArrayList<ByteBuf>(webContext.getContents().size());
                for (HttpContent content : webContext.getContents()) {
                    if (!isMultipart) {
                        byteBuffs.add(content.content().copy());
                    }
                    decoder.offer(content);
                    request.readHttpDataChunkByChunk(decoder);
                    content.release();
                }
                if (!byteBuffs.isEmpty()) {
                    request.setBody(Unpooled.copiedBuffer((ByteBuf[])byteBuffs.toArray(new ByteBuf[0])));
                }
            }
            catch (Exception e) {
                GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                if (bean2 != null) {
                    bean2.handler(e, webContext.getWebkit());
                }
                String message = ExceptionUtil.getMessage(e);
                log.error(message);
                throw new BusinessException(503, "\u751f\u6210\u89e3\u7801\u5668\u5931\u8d25" + message);
            }
        }
        if ((i = req.uri().indexOf("?")) > 0) {
            String uri = req.uri();
            request.setUri(uri.substring(0, i));
        } else {
            request.setUri(req.uri());
        }
        request.setRequestType(req.method());
        ConcurrentHashMap<String, String> headers = new ConcurrentHashMap<String, String>();
        req.headers().names().forEach(a -> headers.put((String)a, req.headers().get(a)));
        request.setHeaders(headers);
        webContext.setRequest(request);
        webContext.setResponse(new Response());
        Webkit webkit = new Webkit();
        webkit.httpRequest = webContext.getRequest();
        webkit.httpResponse = webContext.getResponse();
        webContext.setWebkit(webkit);
        return webContext;
    }

    public static WebContext Statistics(WebContext webContext) {
        if (ConstConfig.isStatisticsOpen.booleanValue()) {
            for (String statisticalRule : ConstConfig.StatisticalRules) {
                if (!webContext.getRequest().getUri().matches(statisticalRule)) continue;
                long startTime = System.currentTimeMillis();
                webContext.regStatistics(stopTime -> {
                    statisticsHandler.uriDataCount(webContext.getRequest().getUri());
                    statisticsHandler.increaseCount();
                    statisticsHandler.addToIpMap(webContext.getCtx());
                    statisticsHandler.addToConnectionDeque(webContext.getCtx(), webContext.getRequest().getUri(), stopTime - startTime);
                });
                break;
            }
        }
        return webContext;
    }

    public static WebContext staticFile(WebContext webContext) {
        if (noStaticFileUri.contains(webContext.getRequest().getUri())) {
            return webContext;
        }
        StaticFile handler = staticHandler.handler(webContext.getRequest().getUri(), webContext);
        if (handler != null) {
            webContext.setStaticFile(true);
            webContext.setStaticFile(handler);
        } else {
            noStaticFileUri.add(webContext.getRequest().getUri());
        }
        return webContext;
    }

    public static WebContext filter(WebContext webContext) {
        if (!FilterChain.filtersIoc.isEmpty()) {
            webContext.setFilter(true);
            try {
                FilterChain.getFileChain().doFilter(webContext.getWebkit());
            }
            catch (Exception e) {
                GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                if (bean2 != null) {
                    bean2.handler(e, webContext.getWebkit());
                    return webContext;
                }
                String message = ExceptionUtil.getMessage(e);
                log.error(message);
                throw new BusinessException(503, "\u62e6\u622a\u5668\u5f02\u5e38" + message);
            }
        }
        return webContext;
    }

    public static WebContext findController(WebContext webContext) {
        if (webContext.isStaticFile()) {
            return webContext;
        }
        RouterInfo routerInfo = RouterManager.getRouterInfo(webContext.getRequest().getUri(), webContext.getRequest().getRequestType());
        if (routerInfo == null) {
            GlobalException bean1 = IocUtil.getBean(GlobalException.class);
            if (bean1 != null) {
                bean1.handler(new NullPointerException("\u4e3a\u627e\u5230\u5bf9\u5e94\u7684\u63a7\u5236\u5668"), webContext.getWebkit());
                return webContext;
            }
            log.error("\u4e3a\u627e\u5230\u5bf9\u5e94\u7684\u63a7\u5236\u5668");
            throw new BusinessException(404, "\u4e3a\u627e\u5230\u5bf9\u5e94\u7684\u63a7\u5236\u5668");
        }
        try {
            Method method = routerInfo.getMethod();
            Class<?> aClass = routerInfo.getaClass();
            Object bean = IocUtil.getBean(aClass);
            try {
                Object[] methodArgs = null;
                try {
                    methodArgs = ParameterUtil.getMethodArgs(aClass, method, webContext);
                }
                catch (Exception e) {
                    GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                    if (bean2 != null) {
                        bean2.handler(e, webContext.getWebkit());
                        return webContext;
                    }
                    String message = ExceptionUtil.getMessage(e);
                    log.error(message);
                    throw new BusinessException(503, "\u751f\u6210\u63a7\u5236\u5668\u65f6\u53c2\u6570\u5f02\u5e38" + message);
                }
                Object res = methodArgs != null ? method.invoke(bean, methodArgs) : method.invoke(bean, new Object[0]);
                if (res == null) {
                    webContext.setResult("");
                } else if (res.getClass().getName().equals("java.lang.String")) {
                    webContext.setResult(res.toString());
                } else {
                    webContext.setResult(JSON.toJSONString((Object)res));
                    webContext.getResponse().setHeader("content-type", "application/json;charset=UTF-8");
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                if (bean2 != null) {
                    bean2.handler(e, webContext.getWebkit());
                    return webContext;
                }
                String message = ExceptionUtil.getMessage(e);
                log.error(message);
                throw new BusinessException(503, "\u8c03\u7528\u65b9\u6cd5\u5931\u8d25" + message);
            }
            catch (IllegalArgumentException e) {
                GlobalException bean1 = IocUtil.getBean(GlobalException.class);
                if (bean1 != null) {
                    bean1.handler(e, webContext.getWebkit());
                    return webContext;
                }
                String message = ExceptionUtil.getMessage(e);
                log.error(message);
                throw new BusinessException(503, "\u8c03\u7528\u63a7\u5236\u5668\u65f6\u53c2\u6570\u5f02\u5e38" + message);
            }
            return webContext;
        }
        catch (BusinessException e) {
            GlobalException bean1 = IocUtil.getBean(GlobalException.class);
            if (bean1 == null) {
                String message = ExceptionUtil.getMessage(e);
                log.error(message);
                throw new BusinessException(e.getHttpCode(), e.getMsg() + message);
            }
            bean1.handler(e, webContext.getWebkit());
            return webContext;
        }
    }

    public static FullHttpResponse buildResponse(WebContext webContext) {
        try {
            DefaultFullHttpResponse response;
            if (webContext.isStaticFile()) {
                response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)webContext.getStaticFile().getByteBuf()));
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(webContext.getStaticFile().getFileHead() + ";charset=UTF-8"));
            } else if (webContext.getResponse().isDownload()) {
                Response response1 = webContext.getResponse();
                response = response1.getFile() == null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)DownLoadUtil.FileToByteBuf(response1.getInputStream()))) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)DownLoadUtil.FileToByteBuf(response1.getFile())));
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/octet-stream;charset=UTF-8");
                response.headers().add((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)String.format("attachment; filename=\"%s\"", webContext.getResponse().getFileName()));
            } else if (webContext.getResponse().getJsonAndHtml() != null) {
                response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])webContext.getResponse().getJsonAndHtml().getBytes(Charset.forName("UTF-8"))));
            } else {
                response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])webContext.getResult().getBytes(Charset.forName("UTF-8"))));
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain;charset=UTF-8");
            }
            response.headers().set((CharSequence)HttpHeaderNames.SERVER, (Object)"HServer");
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            Map<String, String> headers = webContext.getResponse().getHeaders();
            headers.forEach((arg_0, arg_1) -> DispatcherHandler.lambda$buildResponse$2((FullHttpResponse)response, arg_0, arg_1));
            webContext.stopStatistics(System.currentTimeMillis());
            return response;
        }
        catch (Exception e) {
            String message = ExceptionUtil.getMessage(e);
            log.error(message);
            throw new BusinessException(503, "\u6784\u5efaResponse\u5bf9\u8c61\u5f02\u5e38" + message);
        }
    }

    public static FullHttpResponse handleException(Throwable e) {
        BusinessException cause = (BusinessException)e.getCause();
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf((int)cause.getHttpCode());
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus, Unpooled.wrappedBuffer((byte[])cause.getRespMsg().getBytes(Charset.forName("UTF-8"))));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain;charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.SERVER, (Object)"HServer");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        return response;
    }

    public static void writeResponse(ChannelHandlerContext ctx, CompletableFuture<WebContext> future, FullHttpResponse msg) {
        ctx.writeAndFlush((Object)msg);
        future.complete(null);
    }

    private static /* synthetic */ void lambda$buildResponse$2(FullHttpResponse response, String a, String b) {
        response.headers().set(a, (Object)b);
        if (a.equals("location")) {
            response.setStatus(HttpResponseStatus.FOUND);
        }
    }
}

