/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import java.net.InetSocketAddress;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicLong;
import top.hserver.core.server.stat.IpData;
import top.hserver.core.server.stat.RequestData;

public class StatisticsHandler {
    private static final Map<String, IpData> ipMap = new ConcurrentHashMap<String, IpData>();
    private static final Deque<RequestData> logRequestQue = new ConcurrentLinkedDeque<RequestData>();
    private static final AtomicLong uniqueIpCount = new AtomicLong();
    private static final AtomicLong count = new AtomicLong();
    private static final ConcurrentHashMap<String, Long> uriData = new ConcurrentHashMap();

    public void addToConnectionDeque(ChannelHandlerContext ctx, String url, long consumeTime) {
        ChannelTrafficShapingHandler ch = (ChannelTrafficShapingHandler)ctx.channel().pipeline().get("\u7edf\u8ba1");
        ch.trafficCounter().stop();
        logRequestQue.addLast(new RequestData(this.getClientIp(ctx), url, ch.trafficCounter().cumulativeWrittenBytes(), ch.trafficCounter().cumulativeReadBytes(), ch.trafficCounter().lastWriteThroughput(), consumeTime));
        ch.trafficCounter().resetCumulativeTime();
    }

    public void increaseCount() {
        count.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uriDataCount(String uri) {
        ConcurrentHashMap<String, Long> concurrentHashMap = uriData;
        synchronized (concurrentHashMap) {
            Long uriCount = uriData.get(uri);
            if (uriCount == null) {
                uriData.put(uri, 1L);
            } else {
                uriData.put(uri, uriCount + 1L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToIpMap(ChannelHandlerContext ctx) {
        String clientIP = ((InetSocketAddress)ctx.channel().remoteAddress()).getHostString();
        Map<String, IpData> map = ipMap;
        synchronized (map) {
            if (!ipMap.containsKey(clientIP)) {
                ipMap.put(clientIP, new IpData());
                uniqueIpCount.incrementAndGet();
            } else {
                ipMap.get(clientIP).incrementCount();
                ipMap.get(clientIP).updateTime();
            }
        }
    }

    public String getClientIp(ChannelHandlerContext ctx) {
        return ((InetSocketAddress)ctx.channel().remoteAddress()).getHostString();
    }

    public static Map<String, IpData> getIpMap() {
        return ipMap;
    }

    public static Deque<RequestData> getLogRequestQue() {
        return logRequestQue;
    }

    public static AtomicLong getCount() {
        return count;
    }

    public static AtomicLong getUniqueIpCount() {
        return uniqueIpCount;
    }

    public static ConcurrentHashMap<String, Long> getUriData() {
        return uriData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, IpData> removeIpMap() {
        Map<String, IpData> map = ipMap;
        synchronized (map) {
            ConcurrentHashMap<String, IpData> tmpIpMap = new ConcurrentHashMap<String, IpData>();
            tmpIpMap.putAll(ipMap);
            ipMap.clear();
            return tmpIpMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Deque<RequestData> removeLogRequestQue() {
        Deque<RequestData> deque = logRequestQue;
        synchronized (deque) {
            ConcurrentLinkedDeque<RequestData> tmpLogRequestQue = new ConcurrentLinkedDeque<RequestData>();
            tmpLogRequestQue.addAll(logRequestQue);
            logRequestQue.clear();
            return tmpLogRequestQue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtomicLong removeCount() {
        AtomicLong atomicLong = count;
        synchronized (atomicLong) {
            AtomicLong atomicLong2 = new AtomicLong(count.get());
            count.set(0L);
            return atomicLong2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AtomicLong removeUniqueIpCount() {
        AtomicLong atomicLong = uniqueIpCount;
        synchronized (atomicLong) {
            AtomicLong atomicLong2 = new AtomicLong(uniqueIpCount.get());
            uniqueIpCount.set(0L);
            return atomicLong2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConcurrentHashMap<String, Long> removeUriData() {
        ConcurrentHashMap<String, Long> concurrentHashMap = uriData;
        synchronized (concurrentHashMap) {
            ConcurrentHashMap<String, Long> tmpIpMap = new ConcurrentHashMap<String, Long>();
            tmpIpMap.putAll(uriData);
            uriData.clear();
            return tmpIpMap;
        }
    }
}

