/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud.server.handler;

import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.bean.CloudData;
import top.hserver.cloud.bean.InvokeServiceData;
import top.hserver.cloud.bean.ResultData;
import top.hserver.cloud.bean.ServiceData;
import top.hserver.cloud.common.Msg;
import top.hserver.cloud.future.SyncWrite;
import top.hserver.cloud.future.SyncWriteFuture;
import top.hserver.cloud.future.SyncWriteMap;
import top.hserver.cloud.util.DynamicRoundRobin;

public class RpcServerHandler {
    private static final Logger log = LoggerFactory.getLogger(RpcServerHandler.class);
    private static final Map<String, DynamicRoundRobin<ServiceData>> classStringMap = new ConcurrentHashMap<String, DynamicRoundRobin<ServiceData>>();

    public static InvokeServiceData readData(ChannelHandlerContext ctx, Msg msg) {
        switch (msg.getMsg_type()) {
            case REG: {
                CloudData data = (CloudData)msg.getData();
                ServiceData serviceData = new ServiceData();
                serviceData.setName(data.getName());
                serviceData.setCtx(ctx);
                data.getClasses().forEach(a -> {
                    if (classStringMap.containsKey(a)) {
                        classStringMap.get(a).add(serviceData);
                    } else {
                        DynamicRoundRobin<ServiceData> sd = new DynamicRoundRobin<ServiceData>();
                        sd.add(serviceData);
                        classStringMap.put((String)a, sd);
                    }
                });
                log.debug(data.toString());
                break;
            }
            case RESULT: {
                ResultData resultData = (ResultData)msg.getData();
                String requestId = resultData.getUUID();
                SyncWriteFuture future = (SyncWriteFuture)SyncWriteMap.syncKey.get(requestId);
                if (future == null) break;
                future.setResultData(resultData);
            }
        }
        return null;
    }

    public static Object SendInvoker(InvokeServiceData invokeServiceData) throws Exception {
        int size = classStringMap.get(invokeServiceData.getAClass()).size();
        for (int i = 0; i < size; ++i) {
            ServiceData serviceData = classStringMap.get(invokeServiceData.getAClass()).choose();
            if (serviceData == null) continue;
            ChannelHandlerContext ctx = serviceData.getCtx();
            if (ctx != null && ctx.channel().isActive()) {
                ResultData response = new SyncWrite().writeAndSync(ctx, invokeServiceData, 5000L);
                switch (response.getCode()) {
                    case 200: {
                        return response.getData();
                    }
                    case 404: {
                        return new NullPointerException("\u6682\u65e0\u670d\u52a1");
                    }
                }
                return new NullPointerException("\u8fdc\u7a0b\u8c03\u7528\u5f02\u5e38");
            }
            classStringMap.get(invokeServiceData.getAClass()).remove(serviceData);
        }
        return new NullPointerException("\u6682\u65e0\u670d\u52a1");
    }
}

