/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.event;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.event.EventHandleMethod;
import top.hserver.core.event.EventHandleTask;
import top.hserver.core.event.queue.SpongeThreadPoolExecutor;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.ioc.annotation.event.Event;
import top.hserver.core.ioc.annotation.event.EventHandler;
import top.hserver.core.ioc.ref.PackageScanner;

public class EventDispatcher {
    private static final Logger log = LoggerFactory.getLogger(EventDispatcher.class);
    private static Map<String, EventHandleMethod> handleMethodMap = new ConcurrentHashMap<String, EventHandleMethod>();
    private static ExecutorService handlePool = null;

    private EventDispatcher() {
    }

    public static void init(PackageScanner scanner) throws IOException {
        List<Class<?>> classes = scanner.getAnnotationList(EventHandler.class);
        for (Class<?> clazz : classes) {
            Method[] methods;
            EventHandler handlerAnno = clazz.getAnnotation(EventHandler.class);
            if (handlerAnno == null) continue;
            String module = handlerAnno.value();
            Object obj = null;
            try {
                obj = clazz.newInstance();
            }
            catch (Exception e) {
                log.error("initialize " + clazz.getSimpleName() + " error", (Throwable)e);
                continue;
            }
            IocUtil.addBean(clazz.getName(), obj);
            for (Method method : methods = clazz.getDeclaredMethods()) {
                Event eventAnno = method.getAnnotation(Event.class);
                if (eventAnno == null) continue;
                String eventName = eventAnno.value();
                String eventUri = null;
                eventUri = eventName.startsWith("/") ? eventName : module + "/" + eventName;
                handleMethodMap.put(eventUri, new EventHandleMethod(clazz.getName(), method, eventUri));
                log.debug("\u5bfb\u627e\u4e8b\u4ef6 [{}] \u7684\u65b9\u6cd5 [{}.{}]", new Object[]{eventUri, clazz.getSimpleName(), method.getName()});
            }
        }
    }

    public static void startTaskThread() {
        if (handleMethodMap.size() > 0) {
            try {
                String path = System.getProperty("user.dir") + File.separator + "queue";
                File file = new File(path);
                if (!file.exists()) {
                    file.mkdirs();
                }
                int nThreads = Runtime.getRuntime().availableProcessors();
                HashMap<String, String> tmpParmHMap = new HashMap<String, String>();
                tmpParmHMap.put("directory", path);
                handlePool = SpongeThreadPoolExecutor.generateThreadPoolExecutor(nThreads, nThreads * 2, 60L, TimeUnit.SECONDS, tmpParmHMap);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void clearFile() {
        String path = System.getProperty("user.dir") + File.separator + "queue";
        File file = new File(path);
        if (file.exists()) {
            file.delete();
        }
    }

    protected static void dispartchEvent(String eventUri, Map<String, Object> eventParams) {
        EventHandleMethod task = handleMethodMap.get(eventUri);
        if (task == null) {
            log.error("\u4e0d\u5b58\u5728,{},url\u6620\u5c04", (Object)eventUri);
            Set<String> strings = handleMethodMap.keySet();
            log.warn("\u5f53\u524d\u5b58\u5728\u7684 URL\uff0c {}", strings);
            return;
        }
        handlePool.execute(new EventHandleTask(task.getClassName(), eventParams, task.getMethod().getName(), task.getParameterTypes()));
    }
}

