/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.event.queue;

import java.util.ArrayList;
import top.hserver.core.event.queue.PersistenceIntf;
import top.hserver.core.event.queue.SpongeException;
import top.hserver.core.event.queue.util.DataByteArrayOutputStream;
import top.hserver.core.event.queue.util.Utilities;

public abstract class BasePersistence
implements PersistenceIntf {
    private long maxByteArray_Sz = 0x3200000L;
    private ArrayList<byte[]> inMemoryDataList = new ArrayList();
    private int curInMemorySz = 0;
    private final Object ListMutex = new Object();
    private final Object WriteAndReadMutex = new Object();
    private Thread thread;
    private int cnt;
    private boolean isHaveDataInPersistence = false;
    private DataByteArrayOutputStream theOutBytes = null;
    private int oneBatchWriteCnt = 20;
    private long isCanReleaseResTime = -1L;
    private long isCanReleaseResMaxTime = 60000L;
    private int writeOffset = 0;

    public BasePersistence(long maxByteArray_SzParm, int oneBatchWriteCntParm, int isCanReleaseResMaxTimeParm) throws Exception {
        this.maxByteArray_Sz = maxByteArray_SzParm;
        this.oneBatchWriteCnt = oneBatchWriteCntParm;
        this.isCanReleaseResMaxTime = isCanReleaseResMaxTimeParm;
        this.theOutBytes = new DataByteArrayOutputStream(0x100000);
        this.thread = new Thread(){

            @Override
            public void run() {
                BasePersistence.this.processQueue();
            }
        };
        this.thread.setPriority(10);
        this.thread.setDaemon(true);
        this.thread.setName("sponge Data File Writer");
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addOneBatchBytes(byte[] bytesParm) {
        boolean retBool = false;
        ++this.cnt;
        if (this.isCanReleaseResTime != -1L && System.currentTimeMillis() - this.isCanReleaseResTime > this.isCanReleaseResMaxTime) {
            try {
                this.canReleaseRes();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.isCanReleaseResTime = -1L;
        }
        if ((long)(this.curInMemorySz + bytesParm.length) <= this.maxByteArray_Sz) {
            retBool = true;
            Object object = this.ListMutex;
            synchronized (object) {
                this.inMemoryDataList.add(bytesParm);
                this.ListMutex.notifyAll();
            }
            this.curInMemorySz += bytesParm.length;
        } else {
            System.out.println("\u5df2\u7ecf\u8fbe\u5230\u7f13\u51b2\u5668\u7cfb\u7edf\u5904\u7406\u4e0a\u7ebf,\u4e22\u5f03\u6b64\u6b21\u6570\u636e,\u6570\u636e\u5927\u5c0f " + bytesParm.length + "\u3002\u539f\u56e0\u662f\u78c1\u76d8IO\u8d44\u6e90\u4e0d\u8db3\uff0c\u8bf7\u786e\u8ba4!!!");
        }
        return retBool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processQueue() {
        byte[] tmpBytes = null;
        try {
            try {}
            catch (Exception e) {
                e.printStackTrace();
                try {
                    this.destroy();
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            try {
                this.destroy();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        while (true) {
            Object object = this.ListMutex;
            synchronized (object) {
                while (true) {
                    int tmpListSz;
                    if ((tmpListSz = this.inMemoryDataList.size()) > 0) {
                        int tmpThisTimeSaveCnt = this.oneBatchWriteCnt;
                        if (tmpListSz < this.oneBatchWriteCnt) {
                            tmpThisTimeSaveCnt = tmpListSz;
                        }
                        for (int i = 0; i < tmpThisTimeSaveCnt; this.curInMemorySz -= tmpBytes.length, ++i) {
                            tmpBytes = this.inMemoryDataList.remove(0);
                            this.theOutBytes.write(tmpBytes);
                        }
                        break;
                    }
                    this.ListMutex.wait();
                }
                this.ListMutex.notifyAll();
                if (this.theOutBytes.size() <= 0) continue;
            }
            object = this.WriteAndReadMutex;
            synchronized (object) {
                this.doWriteOneBatchBytes(this.theOutBytes.getData(), this.writeOffset, this.theOutBytes.size());
                this.theOutBytes.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] fetchOneBatchBytes() throws SpongeException {
        byte[] retBytes = null;
        try {
            Object object = this.WriteAndReadMutex;
            synchronized (object) {
                retBytes = this.doFetchOneBatchBytes();
                this.isCanReleaseResTime = retBytes == null ? System.currentTimeMillis() : -1L;
                if (retBytes == null && this.theOutBytes.size() > 0) {
                    int tmpByteLength = Utilities.getIntFromBytes(this.theOutBytes.getData(), this.writeOffset + 2);
                    byte[] tmpReadBytes = new byte[tmpByteLength];
                    System.arraycopy(this.theOutBytes.getData(), this.writeOffset, tmpReadBytes, 0, tmpByteLength);
                    retBytes = tmpReadBytes;
                    this.writeOffset += tmpByteLength;
                }
                if (retBytes == null) {
                    Object object2 = this.ListMutex;
                    synchronized (object2) {
                        if (this.inMemoryDataList.size() > 0) {
                            retBytes = this.inMemoryDataList.remove(0);
                            this.curInMemorySz -= retBytes.length;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new SpongeException(ex.getMessage());
        }
        return retBytes;
    }

    public abstract byte[] doFetchOneBatchBytes() throws Exception;

    public abstract void doWriteOneBatchBytes(byte[] var1, int var2, int var3) throws Exception;

    public abstract void doWriteOneBatchBytes(byte[] var1) throws Exception;

    public abstract void destroy() throws Exception;

    public abstract void canReleaseRes() throws Exception;

    @Override
    public boolean isHaveDataInPersistence() {
        return this.isHaveDataInPersistence;
    }

    public void setHaveDataInPersistence(boolean isHaveDataInPersistence) {
        this.isHaveDataInPersistence = isHaveDataInPersistence;
    }
}

