/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.event.queue;

import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import top.hserver.core.event.queue.FilePersistence;
import top.hserver.core.event.queue.PersistenceIntf;
import top.hserver.core.event.queue.SpongeArrayBlockingQueue;
import top.hserver.core.event.queue.SpongeException;
import top.hserver.core.event.queue.SpongeService;
import top.hserver.core.server.epoll.NamedThreadFactory;

public class SpongeThreadPoolExecutor {
    public static final String FilePersistence_Dir = "directory";
    public static final String BlockingQueue_Capacity = "capacity";
    public static final String BlockingQueue_OnePersistLimit = "onePersistLimit";
    public static final String MaxByteArray_Sz = "maxByteArray_Sz";
    public static final String OneBatchWriteCnt = "oneBatchWriteCnt";
    public static final String CanReleaseResMaxTime = "canReleaseResMaxTime";
    public static SpongeArrayBlockingQueue tmpMyArrayBlockingQueue;

    public static ThreadPoolExecutor generateThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit timeUnit, HashMap parmHMap) throws SpongeException {
        String tmpDirectory = null;
        int tmpCapacity = 1000;
        int tmpOnePersistLimit = 100;
        long tmpMaxByteArray_Sz = 0x3200000L;
        int tmpOneBatchWriteCnt = 20;
        int tmpCanReleaseResMaxTime = 60000;
        ThreadPoolExecutor tmpThreadPool = null;
        try {
            if (parmHMap != null) {
                String tmpCanReleaseResMaxTimeStr;
                String tmpOneBatchWriteCntStr;
                String tmpMaxByteArray_SzStr;
                String tmpLimit;
                tmpDirectory = (String)parmHMap.get(FilePersistence_Dir);
                if (tmpDirectory == null) {
                    throw new SpongeException("parmHMap\u91cc\u7f3a\u5c11 directory \u8bbe\u7f6e");
                }
                String tmpCapStr = (String)parmHMap.get(BlockingQueue_Capacity);
                if (tmpCapStr != null) {
                    tmpCapacity = Integer.parseInt(tmpCapStr);
                }
                if ((tmpLimit = (String)parmHMap.get(BlockingQueue_OnePersistLimit)) != null) {
                    tmpOnePersistLimit = Integer.parseInt(tmpLimit);
                }
                if ((tmpMaxByteArray_SzStr = (String)parmHMap.get(MaxByteArray_Sz)) != null) {
                    tmpMaxByteArray_Sz = Long.parseLong(tmpMaxByteArray_SzStr);
                }
                if ((tmpOneBatchWriteCntStr = (String)parmHMap.get(OneBatchWriteCnt)) != null) {
                    tmpOneBatchWriteCnt = Integer.parseInt(tmpOneBatchWriteCntStr);
                }
                if ((tmpCanReleaseResMaxTimeStr = (String)parmHMap.get(CanReleaseResMaxTime)) != null) {
                    tmpCanReleaseResMaxTime = Integer.parseInt(tmpCanReleaseResMaxTimeStr);
                }
            } else {
                throw new SpongeException("parmHMap \u4e0d\u80fd\u4e3anull");
            }
            FilePersistence tmpFilePersistence = new FilePersistence(tmpMaxByteArray_Sz, tmpOneBatchWriteCnt, tmpCanReleaseResMaxTime, tmpDirectory);
            SpongeService tmpSpongeService = new SpongeService(tmpFilePersistence);
            tmpMyArrayBlockingQueue = new SpongeArrayBlockingQueue(tmpCapacity, tmpOnePersistLimit, tmpSpongeService);
            tmpThreadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, (BlockingQueue<Runnable>)tmpMyArrayBlockingQueue, new NamedThreadFactory("hserver_ queue@"));
            tmpMyArrayBlockingQueue.doFetchData_init(tmpThreadPool);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new SpongeException(ex.getLocalizedMessage());
        }
        return tmpThreadPool;
    }

    public static ThreadPoolExecutor generateThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit timeUnit, HashMap parmHMap, PersistenceIntf thePersistenceInsParm) throws SpongeException {
        int tmpCapacity = 500;
        int tmpOnePersistLimit = 100;
        ThreadPoolExecutor tmpThreadPool = null;
        try {
            if (parmHMap != null) {
                String tmpLimit;
                String tmpCapStr = (String)parmHMap.get(BlockingQueue_Capacity);
                if (tmpCapStr != null) {
                    tmpCapacity = Integer.parseInt(tmpCapStr);
                }
                if ((tmpLimit = (String)parmHMap.get(BlockingQueue_OnePersistLimit)) != null) {
                    tmpOnePersistLimit = Integer.parseInt(tmpLimit);
                }
            }
            if (thePersistenceInsParm == null) {
                throw new SpongeException("\u6301\u4e45\u5316\u63d2\u4ef6\u4e0d\u80fd\u4e3anull");
            }
            SpongeService tmpSpongeService = new SpongeService(thePersistenceInsParm);
            SpongeArrayBlockingQueue<Runnable> tmpMyArrayBlockingQueue = new SpongeArrayBlockingQueue<Runnable>(tmpCapacity, tmpOnePersistLimit, tmpSpongeService);
            tmpThreadPool = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, timeUnit, tmpMyArrayBlockingQueue);
            tmpMyArrayBlockingQueue.doFetchData_init(tmpThreadPool);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            throw new SpongeException(ex.getLocalizedMessage());
        }
        return tmpThreadPool;
    }
}

