/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.InputStream;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.event.EventDispatcher;
import top.hserver.core.interfaces.InitRunner;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.server.HttpNettyServerInitializer;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.epoll.EpollKit;
import top.hserver.core.server.epoll.NamedThreadFactory;
import top.hserver.core.server.epoll.NettyServerGroup;
import top.hserver.core.server.util.PropUtil;
import top.hserver.core.task.TaskManager;

public class HServer {
    private static final Logger log = LoggerFactory.getLogger(HServer.class);
    private final int port;
    private final String[] args;

    public HServer(int port, String[] args) {
        this.port = port;
        this.args = args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        NioEventLoopGroup bossGroup = null;
        MultithreadEventLoopGroup workerGroup = null;
        int acceptThreadCount = 2;
        int ioThreadCount = 4;
        try {
            String typeName;
            ServerBootstrap bootstrap = new ServerBootstrap();
            if (EpollKit.epollIsAvailable()) {
                bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
                NettyServerGroup nettyServerGroup = EpollKit.group(acceptThreadCount, ioThreadCount, "hserver");
                bossGroup = nettyServerGroup.getBoosGroup();
                workerGroup = nettyServerGroup.getWorkerGroup();
                bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(nettyServerGroup.getSocketChannel());
                typeName = "Epoll";
            } else {
                bossGroup = new NioEventLoopGroup(acceptThreadCount, (ThreadFactory)new NamedThreadFactory("hserver_boss@"));
                workerGroup = new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedThreadFactory("hserver_ worker@"));
                bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class);
                typeName = "Nio";
            }
            this.initSSl();
            bootstrap.childHandler((ChannelHandler)new HttpNettyServerInitializer());
            Channel ch = bootstrap.bind(this.port).sync().channel();
            log.info("HServer \u542f\u52a8\u5b8c\u6210");
            System.out.println();
            System.out.println(this.getHello(typeName, this.port));
            System.out.println();
            this.initOK();
            ch.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    private void initOK() {
        TaskManager.IS_OK = true;
        InitRunner bean = IocUtil.getBean(InitRunner.class);
        if (bean != null) {
            bean.init(this.args);
        }
        EventDispatcher.startTaskThread();
    }

    private String getHello(String typeName, int port) {
        return "  ___ ___  _________ \t\u65b9\u5f0f\u8fd0\u884c\uff1a" + typeName + "\t\u7aef\u53e3\uff1a" + port + "\n /   |   \\/   _____/ ______________  __ ___________ \n/    ~    \\_____  \\_/ __ \\_  __ \\  \\/ // __ \\_  __ \\\n\\    Y    /        \\  ___/|  | \\/\\   /\\  ___/|  | \\/\n \\___|_  /_______  /\\___  >__|    \\_/  \\___  >__|   \n       \\/        \\/     \\/                 \\/       ";
    }

    private void initSSl() {
        PropUtil instance = PropUtil.getInstance();
        String certFilePath = instance.get("certPath");
        String privateKeyPath = instance.get("privateKeyPath");
        String privateKeyPwd = instance.get("privateKeyPwd");
        if (privateKeyPath == null || certFilePath == null || privateKeyPath.trim().length() == 0 || certFilePath.trim().length() == 0) {
            return;
        }
        try {
            File cfile = new File(certFilePath);
            File pfile = new File(privateKeyPath);
            if (cfile.isFile() && pfile.isFile()) {
                ConstConfig.sslContext = SslContextBuilder.forServer((File)cfile, (File)pfile, (String)privateKeyPwd).build();
                return;
            }
            InputStream cinput = HServer.class.getResourceAsStream("/ssl/" + certFilePath);
            InputStream pinput = HServer.class.getResourceAsStream("/ssl/" + privateKeyPath);
            if (cinput != null && pinput != null) {
                ConstConfig.sslContext = SslContextBuilder.forServer((InputStream)cinput, (InputStream)pinput, (String)privateKeyPwd).build();
                return;
            }
        }
        catch (SSLException s) {
            log.error(s.getMessage());
            s.printStackTrace();
        }
    }
}

