/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerExpectContinueHandler;
import io.netty.handler.traffic.ChannelTrafficShapingHandler;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.handlers.ActionHandler;
import top.hserver.core.server.handlers.ObjectHandler;
import top.hserver.core.server.handlers.WebSocketServerHandler;

public class HttpNettyServerInitializer
extends ChannelInitializer<Channel> {
    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (ConstConfig.isStatisticsOpen.booleanValue()) {
            pipeline.addLast("\u7edf\u8ba1", (ChannelHandler)new ChannelTrafficShapingHandler(1000L));
        }
        if (ConstConfig.sslContext != null) {
            pipeline.addLast(new ChannelHandler[]{ConstConfig.sslContext.newHandler(ch.alloc())});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpServerExpectContinueHandler()});
        if (WebSocketServerHandler.WebSocketRouter.size() > 0) {
            pipeline.addLast(new ChannelHandler[]{new WebSocketServerHandler()});
        }
        pipeline.addLast("\u5bf9\u8c61\u5408\u5e76", (ChannelHandler)new ObjectHandler());
        pipeline.addLast("\u4e1a\u52a1\u5904\u7406", (ChannelHandler)new ActionHandler());
    }
}

