/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.epoll;

import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import java.util.concurrent.ThreadFactory;
import top.hserver.core.server.epoll.NamedThreadFactory;
import top.hserver.core.server.epoll.NettyServerGroup;

public class EpollKit {
    public static NettyServerGroup group(int threadCount, int workers, String name) {
        EpollEventLoopGroup bossGroup = new EpollEventLoopGroup(threadCount, (ThreadFactory)new NamedThreadFactory(name + "_epoll_boss@"));
        EpollEventLoopGroup workerGroup = new EpollEventLoopGroup(workers, (ThreadFactory)new NamedThreadFactory(name + "_epoll_worker@"));
        return NettyServerGroup.builder().boosGroup((MultithreadEventLoopGroup)bossGroup).workerGroup((MultithreadEventLoopGroup)workerGroup).socketChannel(EpollServerSocketChannel.class).build();
    }

    public static boolean epollIsAvailable() {
        try {
            Object obj = Class.forName("io.netty.channel.epoll.Epoll").getMethod("isAvailable", new Class[0]).invoke(null, new Object[0]);
            return null != obj && Boolean.parseBoolean(obj.toString()) && System.getProperty("os.name").toLowerCase().contains("linux");
        }
        catch (Exception e) {
            return false;
        }
    }
}

