/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import com.alibaba.fastjson.JSON;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.GlobalException;
import top.hserver.core.interfaces.PermissionAdapter;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.Request;
import top.hserver.core.server.context.Response;
import top.hserver.core.server.context.StaticFile;
import top.hserver.core.server.context.WebContext;
import top.hserver.core.server.context.Webkit;
import top.hserver.core.server.exception.BusinessException;
import top.hserver.core.server.filter.FilterChain;
import top.hserver.core.server.handlers.BuildResponse;
import top.hserver.core.server.handlers.StaticHandler;
import top.hserver.core.server.handlers.StatisticsHandler;
import top.hserver.core.server.router.RouterInfo;
import top.hserver.core.server.router.RouterManager;
import top.hserver.core.server.router.RouterPermission;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.ParameterUtil;

public class DispatcherHandler {
    private static final Logger log = LoggerFactory.getLogger(DispatcherHandler.class);
    private static final StatisticsHandler statisticsHandler = new StatisticsHandler();
    private static final StaticHandler staticHandler = new StaticHandler();
    private static final HttpDataFactory HTTP_DATA_FACTORY = new DefaultHttpDataFactory(true);
    private static final CopyOnWriteArraySet<String> noStaticFileUri = new CopyOnWriteArraySet();

    static WebContext buildWebContext(ChannelHandlerContext ctx, WebContext webContext) {
        HttpRequest req = webContext.getHttpRequest();
        Request request = new Request();
        request.setIp(statisticsHandler.getClientIp(ctx));
        request.setPort(statisticsHandler.getClientPort(ctx));
        request.setCtx(ctx);
        request.setNettyUri(req.uri());
        webContext.setCtx(ctx);
        if (req.method() == HttpMethod.GET) {
            HashMap<String, String> requestParams = new HashMap<String, String>();
            QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
            Map parame = decoder.parameters();
            for (Map.Entry next : parame.entrySet()) {
                requestParams.put((String)next.getKey(), (String)((List)next.getValue()).get(0));
            }
            request.setRequestParams(requestParams);
        } else {
            try {
                HttpPostRequestDecoder decoder = new HttpPostRequestDecoder(HTTP_DATA_FACTORY, req);
                boolean isMultipart = decoder.isMultipart();
                ArrayList<ByteBuf> byteBuffs = new ArrayList<ByteBuf>(webContext.getContents().size());
                for (HttpContent content : webContext.getContents()) {
                    if (!isMultipart) {
                        byteBuffs.add(content.content().copy());
                    }
                    decoder.offer(content);
                    request.readHttpDataChunkByChunk(decoder);
                    content.release();
                }
                if (!byteBuffs.isEmpty()) {
                    request.setBody(Unpooled.copiedBuffer((ByteBuf[])byteBuffs.toArray(new ByteBuf[0])));
                }
            }
            catch (Exception e) {
                GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                if (bean2 != null) {
                    bean2.handler(e, webContext.getWebkit());
                }
                String message = ExceptionUtil.getMessage(e);
                log.error(message);
                throw new BusinessException(503, "\u751f\u6210\u89e3\u7801\u5668\u5931\u8d25" + message);
            }
        }
        int i = req.uri().indexOf("?");
        if (i > 0) {
            String uri = req.uri();
            request.setUri(uri.substring(0, i));
        } else {
            request.setUri(req.uri());
        }
        request.setRequestType(req.method());
        ConcurrentHashMap<String, String> headers = new ConcurrentHashMap<String, String>();
        req.headers().names().forEach(a -> headers.put((String)a, req.headers().get(a)));
        request.setHeaders(headers);
        webContext.setRequest(request);
        webContext.setResponse(new Response());
        Webkit webkit = new Webkit();
        webkit.httpRequest = webContext.getRequest();
        webkit.httpResponse = webContext.getResponse();
        webContext.setWebkit(webkit);
        return webContext;
    }

    static WebContext Statistics(WebContext webContext) {
        if (ConstConfig.isStatisticsOpen.booleanValue()) {
            for (String statisticalRule : ConstConfig.StatisticalRules) {
                if (!webContext.getRequest().getUri().matches(statisticalRule)) continue;
                long startTime = System.currentTimeMillis();
                webContext.regStatistics(stopTime -> {
                    statisticsHandler.uriDataCount(webContext.getRequest().getUri());
                    statisticsHandler.increaseCount();
                    statisticsHandler.addToIpMap(webContext.getCtx());
                    statisticsHandler.addToConnectionDeque(webContext.getCtx(), webContext.getRequest().getUri(), stopTime - startTime);
                });
                break;
            }
        }
        return webContext;
    }

    static WebContext staticFile(WebContext webContext) {
        if (noStaticFileUri.contains(webContext.getRequest().getUri()) || webContext.getRequest().getRequestType() != HttpMethod.GET) {
            return webContext;
        }
        StaticFile handler = staticHandler.handler(webContext.getRequest().getUri(), webContext);
        if (handler != null) {
            webContext.setStaticFile(true);
            webContext.setStaticFile(handler);
        } else {
            noStaticFileUri.add(webContext.getRequest().getUri());
        }
        return webContext;
    }

    static WebContext Permission(WebContext webContext) {
        RouterPermission routerPermission;
        if (webContext.isStaticFile()) {
            return webContext;
        }
        PermissionAdapter permissionAdapter = IocUtil.getBean(PermissionAdapter.class);
        if (permissionAdapter != null && (routerPermission = RouterManager.getRouterPermission(webContext.getRequest().getUri(), webContext.getRequest().getRequestType())) != null) {
            if (routerPermission.getRequiresPermissions() != null) {
                try {
                    permissionAdapter.requiresPermissions(routerPermission.getRequiresPermissions(), webContext.getWebkit());
                }
                catch (Exception e) {
                    GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                    if (bean2 != null) {
                        bean2.handler(e, webContext.getWebkit());
                        return webContext;
                    }
                    String message = ExceptionUtil.getMessage(e);
                    log.error(message);
                    throw new BusinessException(503, "\u6743\u9650\u9a8c\u8bc1" + message);
                }
            }
            if (routerPermission.getRequiresRoles() != null) {
                try {
                    permissionAdapter.requiresRoles(routerPermission.getRequiresRoles(), webContext.getWebkit());
                }
                catch (Exception e) {
                    GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                    if (bean2 != null) {
                        bean2.handler(e, webContext.getWebkit());
                        return webContext;
                    }
                    String message = ExceptionUtil.getMessage(e);
                    log.error(message);
                    throw new BusinessException(503, "\u89d2\u8272\u9a8c\u8bc1" + message);
                }
            }
            if (routerPermission.getSign() != null) {
                try {
                    permissionAdapter.sign(routerPermission.getSign(), webContext.getWebkit());
                }
                catch (Exception e) {
                    GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                    if (bean2 != null) {
                        bean2.handler(e, webContext.getWebkit());
                        return webContext;
                    }
                    String message = ExceptionUtil.getMessage(e);
                    log.error(message);
                    throw new BusinessException(503, "Sign\u9a8c\u8bc1" + message);
                }
            }
        }
        return webContext;
    }

    public static WebContext filter(WebContext webContext) {
        if (!FilterChain.filtersIoc.isEmpty()) {
            webContext.setFilter(true);
            try {
                FilterChain.getFileChain().doFilter(webContext.getWebkit());
            }
            catch (Exception e) {
                GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                if (bean2 != null) {
                    bean2.handler(e, webContext.getWebkit());
                    return webContext;
                }
                String message = ExceptionUtil.getMessage(e);
                log.error(message);
                throw new BusinessException(503, "\u62e6\u622a\u5668\u5f02\u5e38" + message);
            }
        }
        return webContext;
    }

    static WebContext findController(WebContext webContext) {
        if (webContext.isStaticFile()) {
            return webContext;
        }
        if (webContext.getResponse().getJsonAndHtml() != null || webContext.getResponse().isDownload()) {
            return webContext;
        }
        RouterInfo routerInfo = RouterManager.getRouterInfo(webContext.getRequest().getUri(), webContext.getRequest().getRequestType(), webContext);
        if (routerInfo == null) {
            GlobalException bean1 = IocUtil.getBean(GlobalException.class);
            if (bean1 != null) {
                bean1.handler(new NullPointerException("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u63a7\u5236\u5668\uff0c\u8bf7\u6c42\u65b9\u5f0f\uff1a" + webContext.getRequest().getRequestType().toString()), webContext.getWebkit());
                return webContext;
            }
            log.error("\u672a\u627e\u5230\u5bf9\u5e94\u7684\u63a7\u5236\u5668\uff0c\u8bf7\u6c42\u65b9\u5f0f\uff1a" + webContext.getRequest().getRequestType().toString());
            throw new BusinessException(404, "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u63a7\u5236\u5668\uff0c\u8bf7\u6c42\u65b9\u5f0f\uff1a" + webContext.getRequest().getRequestType().toString());
        }
        try {
            Method method = routerInfo.getMethod();
            Class<?> aClass = routerInfo.getAClass();
            Object bean = IocUtil.getBean(aClass);
            try {
                Object[] methodArgs = null;
                try {
                    methodArgs = ParameterUtil.getMethodArgs(aClass, method, webContext);
                }
                catch (Exception e) {
                    GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                    if (bean2 != null) {
                        bean2.handler(e, webContext.getWebkit());
                        return webContext;
                    }
                    String message = ExceptionUtil.getMessage(e);
                    log.error(message);
                    throw new BusinessException(503, "\u751f\u6210\u63a7\u5236\u5668\u65f6\u53c2\u6570\u5f02\u5e38" + message);
                }
                Object res = method.invoke(bean, methodArgs);
                if (res == null) {
                    webContext.setResult("");
                } else if (res.getClass().getName().equals("java.lang.String")) {
                    webContext.setResult(res.toString());
                } else {
                    webContext.setResult(JSON.toJSONString((Object)res));
                    webContext.getResponse().setHeader("content-type", "application/json;charset=UTF-8");
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                GlobalException bean2 = IocUtil.getBean(GlobalException.class);
                if (bean2 != null) {
                    bean2.handler(e, webContext.getWebkit());
                    return webContext;
                }
                String message = ExceptionUtil.getMessage(e);
                log.error(message);
                throw new BusinessException(503, "\u8c03\u7528\u65b9\u6cd5\u5931\u8d25" + message);
            }
            catch (IllegalArgumentException e) {
                GlobalException bean1 = IocUtil.getBean(GlobalException.class);
                if (bean1 != null) {
                    bean1.handler(e, webContext.getWebkit());
                    return webContext;
                }
                String message = ExceptionUtil.getMessage(e);
                log.error(message);
                throw new BusinessException(503, "\u8c03\u7528\u63a7\u5236\u5668\u65f6\u53c2\u6570\u5f02\u5e38" + message);
            }
            return webContext;
        }
        catch (BusinessException e) {
            GlobalException bean1 = IocUtil.getBean(GlobalException.class);
            if (bean1 == null) {
                String message = ExceptionUtil.getMessage(e);
                log.error(message);
                throw new BusinessException(e.getHttpCode(), e.getMsg() + message);
            }
            bean1.handler(e, webContext.getWebkit());
            return webContext;
        }
    }

    static FullHttpResponse buildResponse(WebContext webContext) {
        try {
            FullHttpResponse response = webContext.isStaticFile() ? BuildResponse.buildStaticShowType(webContext) : (webContext.getResponse().isDownload() ? BuildResponse.buildControllerDownloadType(webContext) : (webContext.getResponse().getJsonAndHtml() != null ? BuildResponse.buildHttpResponseData(webContext) : BuildResponse.buildControllerResult(webContext)));
            return BuildResponse.buildEnd(response, webContext);
        }
        catch (Exception e) {
            String message = ExceptionUtil.getMessage(e);
            log.error(message);
            throw new BusinessException(503, "\u6784\u5efaResponse\u5bf9\u8c61\u5f02\u5e38" + message);
        }
    }

    static FullHttpResponse handleException(Throwable e) {
        return BuildResponse.buildError(e);
    }

    static void writeResponse(ChannelHandlerContext ctx, CompletableFuture<WebContext> future, FullHttpResponse msg) {
        ctx.writeAndFlush((Object)msg);
        future.complete(null);
    }
}

