/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class FileItem {
    private String name;
    private String fileName;
    private String path;
    private String contentType;
    private long length;
    private File file;

    public String extName() {
        return this.fileName.substring(this.fileName.lastIndexOf("."));
    }

    public String toString() {
        long kb = this.length / 1024L;
        return "FileItem(name='" + this.name + '\'' + "fileName='" + this.fileName + '\'' + ", path='" + this.path + '\'' + ", contentType='" + this.contentType + '\'' + ", size=" + (kb < 1L ? 1L : kb) + "KB)";
    }

    public void moveTo(File newFile) throws IOException {
        this.moveTo(Paths.get(newFile.getPath(), new String[0]));
    }

    private void moveTo(Path newFile) throws IOException {
        Files.move(Paths.get(this.file.getPath(), new String[0]), newFile, StandardCopyOption.REPLACE_EXISTING);
    }

    public byte[] getData() {
        byte[] fileContent;
        try {
            fileContent = Files.readAllBytes(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return fileContent;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getPath() {
        return this.path;
    }

    public String getContentType() {
        return this.contentType;
    }

    public long getLength() {
        return this.length;
    }

    public File getFile() {
        return this.file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileItem)) {
            return false;
        }
        FileItem other = (FileItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        return !(this$file == null ? other$file != null : !((Object)this$file).equals(other$file));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        return result;
    }
}

