/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.GlobalException;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.server.context.StaticFile;
import top.hserver.core.server.context.WebContext;
import top.hserver.core.server.exception.BusinessException;
import top.hserver.core.server.util.ExceptionUtil;

public class StaticHandler {
    private static final Logger log = LoggerFactory.getLogger(StaticHandler.class);

    public StaticFile handler(String uri, WebContext webContext) {
        String basePath;
        InputStream input;
        if ("/".equals(uri)) {
            uri = "/index.html";
        }
        if ((input = this.getResourceStreamFromJar((basePath = "/static") + uri)) != null) {
            return this.buildStaticFile(input, uri, webContext);
        }
        return null;
    }

    private InputStream getResourceStreamFromJar(String uri) {
        return StaticHandler.class.getResourceAsStream(uri);
    }

    private StaticFile buildStaticFile(InputStream input, String url, WebContext webContext) {
        StaticFile staticFile = null;
        try {
            int available = input.available();
            staticFile = new StaticFile();
            staticFile.setSize(available);
            int i = url.lastIndexOf("/");
            int i1 = url.lastIndexOf(".");
            if (i <= -1 || i1 <= 0) {
                return null;
            }
            String fileName = url.substring(i + 1, url.length());
            String[] split = fileName.split("\\.");
            staticFile.setFileName(fileName);
            staticFile.setFileType(split[split.length - 1]);
            staticFile.setInputStream(input);
        }
        catch (Exception e) {
            GlobalException bean1 = IocUtil.getBean(GlobalException.class);
            if (bean1 != null) {
                bean1.handler(e, webContext.getWebkit());
            }
            log.error("\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u5f02\u5e38:{}", (Object)e.getMessage());
            throw new BusinessException(503, "\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u5f02\u5e38" + ExceptionUtil.getMessage(e));
        }
        return staticFile;
    }
}

