/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavassistClassLoadUtil {
    private static final Logger log = LoggerFactory.getLogger(JavassistClassLoadUtil.class);

    public static List<Class<?>> LoadClasses(String packageName, boolean recursive) {
        ArrayList classes = new ArrayList();
        String packageDirName = packageName.replace('.', '/');
        try {
            ClassPool cp = ClassPool.getDefault();
            Loader classLoader = new Loader(cp);
            Enumeration dirs = classLoader.getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = (URL)dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    JavassistClassLoadUtil.findAndLoadClassesInPackageByFile(classLoader, packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(classLoader.loadClass(packageName + '.' + className));
                        }
                        catch (Throwable e) {
                            if ("HServerTest".equals(className)) continue;
                            log.error(e.getMessage());
                        }
                    }
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                }
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
        return classes;
    }

    private static void findAndLoadClassesInPackageByFile(Loader classLoader, String packageName, String packagePath, final boolean recursive, List<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                JavassistClassLoadUtil.findAndLoadClassesInPackageByFile(classLoader, packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(classLoader.loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                log.error(e.getMessage());
            }
        }
    }
}

