/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.task;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.TaskJob;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.epoll.NamedThreadFactory;
import top.hserver.core.task.CronExpression;
import top.hserver.core.task.ScheduledThreadPoolExecutorPro;

public class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    public static Boolean IS_OK = false;
    private static final Map<String, ScheduledFuture<?>> cronTask = new ConcurrentHashMap();
    private static final ScheduledThreadPoolExecutorPro scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutorPro((int)ConstConfig.taskPool, new NamedThreadFactory("hserver_task@"));

    public static void addTask(String name, String time, Class<? extends TaskJob> taskJob, Object ... args) {
        try {
            if (cronTask.containsKey(name)) {
                log.warn("{}\u4efb\u52a1\u540d\u5df2\u7ecf\u5b58\u5728", (Object)name);
                return;
            }
            TaskJob taskJob1 = taskJob.newInstance();
            try {
                CronExpression expression = new CronExpression(time);
                ScheduledFuture<?> submit = scheduledThreadPoolExecutor.submit(expression, taskJob1, args);
                cronTask.put(name, submit);
            }
            catch (Exception e) {
                try {
                    int times = Integer.parseInt(time);
                    ScheduledFuture<?> submit = scheduledThreadPoolExecutor.submit((Integer)times, taskJob1, args);
                    cronTask.put(name, submit);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean removeTask(String name) {
        ScheduledFuture<?> scheduledFuture = cronTask.get(name);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
            cronTask.remove(name);
            return true;
        }
        return false;
    }

    public static void initTask(String name, String time, String className, Method method, Object ... args) {
        if (cronTask.containsKey(name)) {
            log.warn("{}\u4efb\u52a1\u540d\u5df2\u7ecf\u5b58\u5728", (Object)name);
            return;
        }
        try {
            CronExpression expression = new CronExpression(time);
            ScheduledFuture<?> submit = scheduledThreadPoolExecutor.submit(expression, className, method, args);
            cronTask.put(name, submit);
        }
        catch (Exception e) {
            try {
                int times = Integer.parseInt(time);
                ScheduledFuture<?> submit = scheduledThreadPoolExecutor.submit((Integer)times, className, method, args);
                cronTask.put(name, submit);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

