/*
 * Decompiled with CFR 0.152.
 */
package top.hserver;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.CloudManager;
import top.hserver.core.event.EventDispatcher;
import top.hserver.core.ioc.ref.InitBean;
import top.hserver.core.ioc.ref.MemoryInitClass;
import top.hserver.core.properties.PropertiesInit;
import top.hserver.core.server.HServer;

public class HServerApplication {
    private static final Logger log = LoggerFactory.getLogger(HServerApplication.class);

    public static void run(Class classz, Integer port, String ... args) {
        if (classz == null || port == null) {
            log.info("HServer \u542f\u52a8\u5931\u8d25");
            return;
        }
        HServerApplication.iocInit(classz);
        HServerApplication.startServer(port, args);
    }

    public static void run(Integer port, String ... args) {
        HServerApplication.iocInit(new Class[0]);
        HServerApplication.startServer(port, args);
    }

    private static void startServer(int port, String[] args) {
        CloudManager.run();
        try {
            new HServer(port, args).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void iocInit(Class ... classz) {
        for (Class aClass : classz) {
            MemoryInitClass.init(aClass);
        }
        MemoryInitClass.init(HServerApplication.class);
        log.info("\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6");
        PropertiesInit.init();
        log.info("\u521d\u59cb\u5316\u914d\u7f6e\u5b8c\u6210");
        log.info("HServer \u542f\u52a8\u4e2d....");
        log.info("Package \u626b\u63cf\u4e2d");
        InitBean.init(HServerApplication.class);
        for (Class aClass : classz) {
            InitBean.init(aClass);
        }
        log.info("IOC \u88c5\u914d\u4e2d");
        InitBean.injection();
        InitBean.BeetlSqlinit();
        log.info("IOC \u5168\u90e8\u88c5\u914d\u5b8c\u6210");
    }

    public static void runTest(List<Class> list) {
        HServerApplication.iocInit(list.toArray(new Class[list.size()]));
        EventDispatcher.startTaskThread();
    }
}

