/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.bean.ClientData;
import top.hserver.cloud.client.ChatClient;
import top.hserver.cloud.proxy.CloudProxy;
import top.hserver.cloud.server.RegServer;
import top.hserver.cloud.task.BroadcastTask;
import top.hserver.cloud.util.NetUtil;
import top.hserver.core.server.util.PropUtil;
import top.hserver.core.task.TaskManager;

public class CloudManager {
    private static final Logger log = LoggerFactory.getLogger(CloudManager.class);
    public static int port = 9527;
    private static Map<String, ClientData> serviceDataMap = new ConcurrentHashMap<String, ClientData>();

    public static void run() {
        block6: {
            CloudProxy.clearCache();
            try {
                PropUtil propKit = new PropUtil();
                String open = propKit.get("app.cloud.open");
                if (open == null || !Boolean.parseBoolean(open.toString())) break block6;
                String master_open = propKit.get("app.cloud.master.open");
                if (master_open != null && Boolean.parseBoolean(master_open.toString())) {
                    new RegServer(port).start();
                }
                port = Integer.parseInt(propKit.get("app.cloud.port", "9527"));
                String slave_open = propKit.get("app.cloud.slave.open");
                if (slave_open == null || !Boolean.parseBoolean(slave_open.toString())) break block6;
                String cloud_name = propKit.get("app.cloud.slave.name");
                cloud_name = cloud_name == null ? NetUtil.getIpAddress() : cloud_name + "-->" + NetUtil.getIpAddress();
                String host = null;
                try {
                    host = propKit.get("app.cloud.slave.master.host");
                    if (host != null) {
                        new ChatClient(host.toString(), port).start();
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                TaskManager.addTask(cloud_name.toString(), "5000", BroadcastTask.class, cloud_name.toString(), host);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    public static void add(String name, ClientData classs) {
        if (serviceDataMap.containsKey(name)) {
            log.warn("\u5df2\u7ecf\u5b58\u5728\uff1a{}Rpc\u670d\u52a1", (Object)name);
            return;
        }
        serviceDataMap.put(name, classs);
    }

    public static boolean isRpcService() {
        return serviceDataMap.size() > 0;
    }

    public static List<String> getClasses() {
        ArrayList<String> list = new ArrayList<String>();
        serviceDataMap.forEach((a, b) -> list.add(b.getAClass()));
        return list;
    }

    public static ClientData get(String name) {
        return serviceDataMap.get(name);
    }
}

