/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud.client.handler;

import io.netty.channel.ChannelHandlerContext;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.CloudManager;
import top.hserver.cloud.bean.ClientData;
import top.hserver.cloud.bean.InvokeServiceData;
import top.hserver.cloud.bean.ResultData;
import top.hserver.cloud.common.MSG_TYPE;
import top.hserver.cloud.common.Msg;
import top.hserver.core.ioc.IocUtil;

public class InvokerHandler {
    private static final Logger log = LoggerFactory.getLogger(InvokerHandler.class);

    public static Msg<ResultData> Invoker(InvokeServiceData data) {
        if (data != null) {
            log.debug("\u8c03\u7528\u4fe1\u606f--->{}", (Object)data.toString());
            String aClass = data.getAClass();
            ClientData clientData = CloudManager.get(aClass);
            Object bean = IocUtil.getBean(aClass);
            for (Method method : clientData.getMethods()) {
                if (!method.getName().equals(data.getMethod())) continue;
                try {
                    Object invoke = method.invoke(bean, data.getObjects());
                    ResultData resultData = new ResultData();
                    resultData.setData(invoke);
                    resultData.setUUID(data.getUUID());
                    resultData.setCode(200);
                    Msg<ResultData> msg2 = new Msg<ResultData>();
                    msg2.setMsg_type(MSG_TYPE.RESULT);
                    msg2.setData(resultData);
                    return msg2;
                }
                catch (Exception e) {
                    ResultData resultData = new ResultData();
                    resultData.setData(e.getMessage());
                    resultData.setUUID(data.getUUID());
                    resultData.setCode(503);
                    Msg<ResultData> msg2 = new Msg<ResultData>();
                    msg2.setMsg_type(MSG_TYPE.RESULT);
                    msg2.setData(resultData);
                    return msg2;
                }
            }
        }
        ResultData resultData = new ResultData();
        resultData.setData("\u7a7a\u8c03\u7528");
        resultData.setCode(503);
        Msg<ResultData> msg2 = new Msg<ResultData>();
        msg2.setMsg_type(MSG_TYPE.RESULT);
        msg2.setData(resultData);
        return msg2;
    }

    public static InvokeServiceData buildContext(ChannelHandlerContext ctx, Msg msg) {
        if (msg.getMsg_type() == MSG_TYPE.INVOKER) {
            InvokeServiceData data = (InvokeServiceData)msg.getData();
            return data;
        }
        return null;
    }

    public static Msg<ResultData> handleException(Throwable e) {
        ResultData resultData = new ResultData();
        resultData.setData(e.getMessage());
        resultData.setCode(503);
        Msg<ResultData> msg2 = new Msg<ResultData>();
        msg2.setMsg_type(MSG_TYPE.RESULT);
        msg2.setData(resultData);
        return msg2;
    }

    static void writeResponse(ChannelHandlerContext ctx, CompletableFuture<Msg> future, Msg msg) {
        ctx.writeAndFlush((Object)msg);
        future.complete(null);
    }
}

