/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultithreadEventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.server.handler.RpcServerInitializer;
import top.hserver.core.server.epoll.EpollKit;
import top.hserver.core.server.epoll.NamedThreadFactory;
import top.hserver.core.server.epoll.NettyServerGroup;

public class RegServer
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(RegServer.class);
    private final int port;

    public RegServer(int port) {
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        NioEventLoopGroup bossGroup = null;
        MultithreadEventLoopGroup workerGroup = null;
        int acceptThreadCount = 1;
        int ioThreadCount = 0;
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            if (EpollKit.epollIsAvailable()) {
                bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
                NettyServerGroup nettyServerGroup = EpollKit.group(acceptThreadCount, ioThreadCount, "hserver_rpc");
                bossGroup = nettyServerGroup.getBoosGroup();
                workerGroup = nettyServerGroup.getWorkerGroup();
                bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(nettyServerGroup.getSocketChannel());
            } else {
                bossGroup = new NioEventLoopGroup(acceptThreadCount, (ThreadFactory)new NamedThreadFactory("hserver_rpc_boss@"));
                workerGroup = new NioEventLoopGroup(ioThreadCount, (ThreadFactory)new NamedThreadFactory("hserver_rpc_ worker@"));
                bootstrap.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class);
            }
            bootstrap.childHandler((ChannelHandler)new RpcServerInitializer());
            Channel ch = bootstrap.bind(this.port).sync().channel();
            ch.closeFuture().sync();
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }
}

