/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud.server.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.common.Msg;
import top.hserver.cloud.server.handler.RpcServerHandler;

public class ServerHandler
extends SimpleChannelInboundHandler<Msg> {
    private static final Logger log = LoggerFactory.getLogger(ServerHandler.class);

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, Msg msg) throws Exception {
        CompletableFuture<Msg> futures = CompletableFuture.completedFuture(msg);
        EventExecutor executor = channelHandlerContext.executor();
        futures.thenApplyAsync(e -> RpcServerHandler.readData(channelHandlerContext, msg), (Executor)executor);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        cause.printStackTrace();
        ctx.close();
    }
}

