/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.cloud.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class DynamicRoundRobin<T> {
    private final List<T> list = new CopyOnWriteArrayList<T>();
    private AtomicInteger pos = new AtomicInteger(0);

    public void add(T t) {
        if (!this.list.contains(t)) {
            this.list.add(t);
        }
    }

    public boolean remove(T t) {
        return this.list.remove(t);
    }

    public int size() {
        return this.list.size();
    }

    public T choose() {
        int size;
        while ((size = this.list.size()) != 0) {
            int p = this.pos.getAndIncrement();
            if (p > size - 1) {
                this.pos.set(0);
                continue;
            }
            try {
                return this.list.get(p);
            }
            catch (IndexOutOfBoundsException e) {
                this.pos.set(0);
                continue;
            }
            break;
        }
        return null;
    }
}

