/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.event;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.ioc.IocUtil;

public class EventHandleTask
implements Runnable,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(EventHandleTask.class);
    private Map<String, Object> eventParams;
    private String methodName;
    private String uri;
    private String className;
    private Class<?>[] parameterTypes;

    public EventHandleTask(String className, Map<String, Object> eventParams, String methodName, Class<?>[] parameterTypes) {
        this.eventParams = eventParams;
        if (this.eventParams == null) {
            this.eventParams = Collections.emptyMap();
        }
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.className = className;
    }

    @Override
    public void run() {
        log.debug("\u8fd0\u884ceventHandleTask\uff0c\u4e8b\u4ef6URI: {}, \u4e8b\u4ef6\u53c2\u6570: {}", (Object)this.uri, this.eventParams);
        long t0 = System.currentTimeMillis();
        try {
            Class<?> cl = ClassLoader.getSystemClassLoader().loadClass(this.className);
            Method method = cl.getMethod(this.methodName, this.parameterTypes);
            method.invoke(IocUtil.getBean(this.className), this.eventParams);
            log.debug("\u8fd0\u884c eventHandleTask \u6210\u529f, \u8017\u65f6 {}ms", (Object)(System.currentTimeMillis() - t0));
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                e = (Exception)e.getCause();
            }
            log.error("\u8fd0\u884c eventHandleTask \u9519\u8bef", (Throwable)e);
        }
    }

    public Map<String, Object> getEventParams() {
        return this.eventParams;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getUri() {
        return this.uri;
    }

    public String getClassName() {
        return this.className;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setEventParams(Map<String, Object> eventParams) {
        this.eventParams = eventParams;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventHandleTask)) {
            return false;
        }
        EventHandleTask other = (EventHandleTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$eventParams = this.getEventParams();
        Map<String, Object> other$eventParams = other.getEventParams();
        if (this$eventParams == null ? other$eventParams != null : !((Object)this$eventParams).equals(other$eventParams)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        return Arrays.deepEquals(this.getParameterTypes(), other.getParameterTypes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventHandleTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $eventParams = this.getEventParams();
        result = result * 59 + ($eventParams == null ? 43 : ((Object)$eventParams).hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getParameterTypes());
        return result;
    }

    public String toString() {
        return "EventHandleTask(eventParams=" + this.getEventParams() + ", methodName=" + this.getMethodName() + ", uri=" + this.getUri() + ", className=" + this.getClassName() + ", parameterTypes=" + Arrays.deepToString(this.getParameterTypes()) + ")";
    }
}

