/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.event.queue;

import java.io.File;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.event.queue.BasePersistence;
import top.hserver.core.event.queue.util.RAcsFile;
import top.hserver.core.event.queue.util.Utilities;

public class FilePersistence
extends BasePersistence {
    private static final Logger log = LoggerFactory.getLogger(FilePersistence.class);
    private String directory;
    private RAcsFile theWriteDataFile;
    private RAcsFile theReadDataFile;
    private RAcsFile theFetchPosiFile;
    private boolean forceToDisk = true;
    private long curFetchPosi;
    private static final String DataFile_Name = "dataFile.data";
    private static final String FetchPosiFile_Name = "fetchPosiFile.data";

    public FilePersistence(long maxByteArray_SzParm, int oneBatchWriteCntParm, int isCanReleaseResMaxTimeParm, String directoryParm) throws Exception {
        super(maxByteArray_SzParm, oneBatchWriteCntParm, isCanReleaseResMaxTimeParm);
        this.directory = directoryParm;
        if (!directoryParm.endsWith("/")) {
            this.directory = this.directory + "/";
        }
        this.theWriteDataFile = new RAcsFile(this.directory + DataFile_Name);
        this.theReadDataFile = new RAcsFile(this.directory + DataFile_Name, "r");
        this.theFetchPosiFile = new RAcsFile(this.directory + FetchPosiFile_Name);
        this.initCurFetchPosi();
        this.theWriteDataFile.getDataFile().seek(this.theWriteDataFile.getFileLength());
    }

    private void initCurFetchPosi() {
        try {
            if (this.theFetchPosiFile.getFileLength() == 8L) {
                this.curFetchPosi = this.theFetchPosiFile.getDataFile().readLong();
            }
            this.theReadDataFile.getDataFile().seek(this.curFetchPosi);
            if (this.curFetchPosi < this.theReadDataFile.getFileLength()) {
                this.setHaveDataInPersistence(true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public byte[] doFetchOneBatchBytes() throws Exception {
        byte[] tmpLengthByte = new byte[6];
        int tmpReadCnt = this.theReadDataFile.getDataFile().read(tmpLengthByte);
        if (tmpReadCnt == -1) {
            return null;
        }
        int tmpByteLength = Utilities.getIntFromBytes(tmpLengthByte, 2);
        byte[] tmpReadBytes = new byte[tmpByteLength];
        tmpReadCnt = this.theReadDataFile.getDataFile().read(tmpReadBytes, 6, tmpByteLength - 6);
        if (tmpReadCnt == -1) {
            return null;
        }
        this.curFetchPosi += (long)tmpByteLength;
        byte[] tmpBytes = Utilities.getBytesFromLong(this.curFetchPosi);
        this.theFetchPosiFile.getDataFile().seek(0L);
        this.theFetchPosiFile.getDataFile().write(tmpBytes);
        this.theFetchPosiFile.getDataFile().getFD().sync();
        return tmpReadBytes;
    }

    @Override
    public void doWriteOneBatchBytes(byte[] writeBytesParm, int offsetParm, int lengthParm) throws Exception {
        long tmpStartTime = System.currentTimeMillis();
        RandomAccessFile file = this.theWriteDataFile.getDataFile();
        file.write(writeBytesParm, offsetParm, lengthParm);
        if (this.forceToDisk) {
            file.getFD().sync();
        }
        log.debug("\u4e00\u6b21\u5199\u5165\u8017\u65f6 {}", (Object)(System.currentTimeMillis() - tmpStartTime));
    }

    @Override
    public void destroy() throws Exception {
        this.theWriteDataFile.close();
        this.theReadDataFile.close();
    }

    @Override
    public void doWriteOneBatchBytes(byte[] writeBytesParm) throws Exception {
        this.doWriteOneBatchBytes(writeBytesParm, 0, writeBytesParm.length);
    }

    @Override
    public void canReleaseRes() throws Exception {
        if (this.curFetchPosi != 0L) {
            this.theWriteDataFile.destroy();
            this.theReadDataFile.destroy();
            this.theWriteDataFile = null;
            this.theReadDataFile = null;
            File tmpFile = new File(this.directory + DataFile_Name);
            this.deleteFile(tmpFile);
            this.curFetchPosi = 0L;
            this.theFetchPosiFile.getDataFile().seek(0L);
            this.theFetchPosiFile.getDataFile().write(Utilities.getBytesFromLong(this.curFetchPosi));
            this.theFetchPosiFile.getDataFile().getFD().sync();
            this.theWriteDataFile = new RAcsFile(this.directory + DataFile_Name);
            this.theReadDataFile = new RAcsFile(this.directory + DataFile_Name, "r");
        }
    }

    private boolean deleteFile(File fileToDelete) {
        if (fileToDelete == null || !fileToDelete.exists()) {
            return true;
        }
        boolean result = fileToDelete.delete();
        return result;
    }
}

