/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.event.queue.util;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataByteArrayOutputStream
extends OutputStream
implements DataOutput {
    private static final int DEFAULT_SIZE = 4096;
    protected byte[] buf;
    protected int pos;

    public DataByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        this.buf = new byte[size];
    }

    public DataByteArrayOutputStream() {
        this(4096);
    }

    public void restart(int size) {
        this.buf = new byte[size];
        this.pos = 0;
    }

    public void restart() {
        this.restart(4096);
    }

    @Override
    public void write(int b) throws IOException {
        int newcount = this.pos + 1;
        this.ensureEnoughBuffer(newcount);
        this.buf[this.pos] = (byte)b;
        this.pos = newcount;
        this.onWrite();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        int newcount = this.pos + len;
        this.ensureEnoughBuffer(newcount);
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos = newcount;
        this.onWrite();
    }

    public byte[] getData() {
        return this.buf;
    }

    public byte[] getDataClone() {
        byte[] retBytes = new byte[this.pos];
        System.arraycopy(this.buf, 0, retBytes, 0, this.pos);
        return retBytes;
    }

    public void reset() {
        this.pos = 0;
    }

    public void position(int offset) throws IOException {
        this.ensureEnoughBuffer(offset);
        this.pos = offset;
        this.onWrite();
    }

    public int size() {
        return this.pos;
    }

    public void setSize(int newSzParm) {
        this.pos = newSzParm;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.ensureEnoughBuffer(this.pos + 1);
        this.buf[this.pos++] = (byte)(v ? 1 : 0);
        this.onWrite();
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.ensureEnoughBuffer(this.pos + 1);
        this.buf[this.pos++] = (byte)(v >>> 0);
        this.onWrite();
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.ensureEnoughBuffer(this.pos + 2);
        this.buf[this.pos++] = (byte)(v >>> 8);
        this.buf[this.pos++] = (byte)(v >>> 0);
        this.onWrite();
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.ensureEnoughBuffer(this.pos + 2);
        this.buf[this.pos++] = (byte)(v >>> 8);
        this.buf[this.pos++] = (byte)(v >>> 0);
        this.onWrite();
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.ensureEnoughBuffer(this.pos + 4);
        this.buf[this.pos++] = (byte)(v >>> 24);
        this.buf[this.pos++] = (byte)(v >>> 16);
        this.buf[this.pos++] = (byte)(v >>> 8);
        this.buf[this.pos++] = (byte)(v >>> 0);
        this.onWrite();
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.ensureEnoughBuffer(this.pos + 8);
        this.buf[this.pos++] = (byte)(v >>> 56);
        this.buf[this.pos++] = (byte)(v >>> 48);
        this.buf[this.pos++] = (byte)(v >>> 40);
        this.buf[this.pos++] = (byte)(v >>> 32);
        this.buf[this.pos++] = (byte)(v >>> 24);
        this.buf[this.pos++] = (byte)(v >>> 16);
        this.buf[this.pos++] = (byte)(v >>> 8);
        this.buf[this.pos++] = (byte)(v >>> 0);
        this.onWrite();
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            this.write((byte)s.charAt(i));
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            this.write(c >>> 8 & 0xFF);
            this.write(c >>> 0 & 0xFF);
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        int i;
        int strlen = str.length();
        int encodedsize = 0;
        for (i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++encodedsize;
                continue;
            }
            if (c > '\u07ff') {
                encodedsize += 3;
                continue;
            }
            encodedsize += 2;
        }
        if (encodedsize > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + encodedsize + " bytes");
        }
        this.ensureEnoughBuffer(this.pos + encodedsize + 2);
        this.writeShort(encodedsize);
        for (i = 0; i < strlen; ++i) {
            char charValue = str.charAt(i);
            if (charValue > '\u0000' && charValue <= '\u007f') {
                this.buf[this.pos++] = (byte)charValue;
                continue;
            }
            if (charValue <= '\u07ff') {
                this.buf[this.pos++] = (byte)(0xC0 | 0x1F & charValue >> 6);
                this.buf[this.pos++] = (byte)(0x80 | 0x3F & charValue);
                continue;
            }
            this.buf[this.pos++] = (byte)(0xE0 | 0xF & charValue >> 12);
            this.buf[this.pos++] = (byte)(0x80 | 0x3F & charValue >> 6);
            this.buf[this.pos++] = (byte)(0x80 | 0x3F & charValue);
        }
        this.onWrite();
    }

    public void ensureEnoughBuffer(int newcount) {
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[newcount + 0x500000];
            System.arraycopy(this.buf, 0, newbuf, 0, this.pos);
            this.buf = newbuf;
        }
    }

    protected void onWrite() throws IOException {
    }

    public void skip(int size) throws IOException {
        this.ensureEnoughBuffer(this.pos + size);
        this.pos += size;
        this.onWrite();
    }
}

