/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.ioc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.ioc.Ioc;

public class HServerIoc
implements Ioc {
    private static final Logger log = LoggerFactory.getLogger(HServerIoc.class);
    private static final Map<String, Object> pool = new ConcurrentHashMap<String, Object>(32);

    @Override
    public Map<String, Object> getAll() {
        return pool;
    }

    @Override
    public <T> T getBean(Class<T> type) {
        if (type != null) {
            Object o = pool.get(type.getName());
            return type.cast(o);
        }
        return null;
    }

    @Override
    public Object getBean(String beanName) {
        if (beanName != null && beanName.trim().length() > 0) {
            return pool.get(beanName);
        }
        return null;
    }

    @Override
    public <T> T getBean(String beanName, Class<T> type) {
        try {
            if (type != null && beanName != null && beanName.trim().length() > 0) {
                Object o = pool.get(beanName);
                return type.cast(o);
            }
        }
        catch (Exception e) {
            log.warn("{}\u8f6c\u6362\u5f02\u5e38{}", (Object)beanName, (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public void addBean(Object bean) {
        if (bean != null) {
            String name = bean.getClass().getName();
            this.addBean(name, bean);
        }
    }

    @Override
    public void addBean(String name, Object bean) {
        if (name != null && name.trim().length() > 0 && bean != null) {
            pool.put(name, bean);
        }
    }

    @Override
    public void remove(Class<?> type) {
        String name;
        if (type != null && pool.containsKey(name = type.getName())) {
            pool.remove(name);
        }
    }

    @Override
    public void remove(String beanName) {
        if (beanName != null && pool.containsKey(beanName)) {
            pool.remove(beanName);
        }
    }

    @Override
    public void clearAll() {
        pool.clear();
    }

    @Override
    public boolean exist(String beanName) {
        if (beanName != null && beanName.trim().length() > 0) {
            return pool.containsKey(beanName);
        }
        return false;
    }

    @Override
    public boolean exist(Class<?> type) {
        if (type != null) {
            String name = type.getName();
            return pool.containsKey(name);
        }
        return false;
    }
}

