/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.ioc.ref;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.ioc.annotation.Configuration;
import top.hserver.core.ioc.annotation.Controller;
import top.hserver.core.ioc.annotation.Filter;
import top.hserver.core.ioc.annotation.Hook;
import top.hserver.core.ioc.annotation.WebSocket;
import top.hserver.core.ioc.annotation.event.EventHandler;
import top.hserver.core.ioc.ref.PackageScanner;
import top.hserver.core.server.util.ClassLoadUtil;

public class ClasspathPackageScanner
implements PackageScanner {
    private static final Logger log = LoggerFactory.getLogger(ClasspathPackageScanner.class);
    private Map<Class, List<Class<?>>> annotationClass = new HashMap();

    public ClasspathPackageScanner(String basePackage) {
        List<Class<?>> classes = ClassLoadUtil.LoadClasses(basePackage, true, false);
        for (Class<?> aClass : classes) {
            if (aClass.getAnnotation(Bean.class) != null) {
                this.add(aClass, Bean.class);
            }
            if (aClass.getAnnotation(WebSocket.class) != null) {
                this.add(aClass, WebSocket.class);
            }
            if (aClass.getAnnotation(Configuration.class) != null) {
                this.add(aClass, Configuration.class);
            }
            if (aClass.getAnnotation(Controller.class) != null) {
                this.add(aClass, Controller.class);
            }
            if (aClass.getAnnotation(Hook.class) != null) {
                this.add(aClass, Hook.class);
            }
            if (aClass.getAnnotation(Filter.class) != null) {
                this.add(aClass, Filter.class);
            }
            if (aClass.getAnnotation(EventHandler.class) != null) {
                this.add(aClass, EventHandler.class);
            }
            try {
                Class<?> aClass1 = this.getClass().getClassLoader().loadClass("org.junit.runner.RunWith");
                if (aClass.getAnnotation(aClass1) == null) continue;
                this.add(aClass, aClass1);
            }
            catch (Exception exception) {}
        }
    }

    private <A extends Annotation> void add(Class<?> aClass, Class<A> annotation) {
        List<Class<?>> classes = this.annotationClass.get(annotation);
        if (classes == null) {
            classes = new ArrayList();
            classes.add(aClass);
            this.annotationClass.put(annotation, classes);
        } else {
            classes.add(aClass);
            this.annotationClass.put(annotation, classes);
        }
    }

    @Override
    public <A extends Annotation> List<Class<?>> getAnnotationList(Class<A> annotation) throws IOException {
        List<Class<?>> classes = this.annotationClass.get(annotation);
        if (classes == null) {
            return new ArrayList();
        }
        return classes;
    }
}

