/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.ioc.ref;

import io.netty.handler.codec.http.HttpMethod;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.cloud.CloudManager;
import top.hserver.cloud.bean.ClientData;
import top.hserver.cloud.proxy.CloudProxy;
import top.hserver.core.event.EventDispatcher;
import top.hserver.core.interfaces.AnnotationAdapter;
import top.hserver.core.interfaces.FilterAdapter;
import top.hserver.core.interfaces.GlobalException;
import top.hserver.core.interfaces.InitRunner;
import top.hserver.core.interfaces.PermissionAdapter;
import top.hserver.core.interfaces.TrackAdapter;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.ioc.annotation.Autowired;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.ioc.annotation.BeetlSQL;
import top.hserver.core.ioc.annotation.CONNECT;
import top.hserver.core.ioc.annotation.Configuration;
import top.hserver.core.ioc.annotation.Controller;
import top.hserver.core.ioc.annotation.DELETE;
import top.hserver.core.ioc.annotation.Filter;
import top.hserver.core.ioc.annotation.GET;
import top.hserver.core.ioc.annotation.HEAD;
import top.hserver.core.ioc.annotation.Hook;
import top.hserver.core.ioc.annotation.OPTIONS;
import top.hserver.core.ioc.annotation.PATCH;
import top.hserver.core.ioc.annotation.POST;
import top.hserver.core.ioc.annotation.PUT;
import top.hserver.core.ioc.annotation.RequestMapping;
import top.hserver.core.ioc.annotation.RequestMethod;
import top.hserver.core.ioc.annotation.RequiresPermissions;
import top.hserver.core.ioc.annotation.RequiresRoles;
import top.hserver.core.ioc.annotation.Resource;
import top.hserver.core.ioc.annotation.RpcService;
import top.hserver.core.ioc.annotation.Sign;
import top.hserver.core.ioc.annotation.TRACE;
import top.hserver.core.ioc.annotation.Task;
import top.hserver.core.ioc.annotation.Value;
import top.hserver.core.ioc.annotation.WebSocket;
import top.hserver.core.ioc.ref.ClasspathPackageScanner;
import top.hserver.core.ioc.ref.PackageScanner;
import top.hserver.core.proxy.JavassistProxyFactory;
import top.hserver.core.server.filter.FilterChain;
import top.hserver.core.server.handlers.WebSocketServerHandler;
import top.hserver.core.server.router.RouterInfo;
import top.hserver.core.server.router.RouterManager;
import top.hserver.core.server.router.RouterPermission;
import top.hserver.core.server.util.ParameterUtil;
import top.hserver.core.server.util.PropUtil;
import top.hserver.core.task.TaskManager;

public class InitBean {
    private static final Logger log = LoggerFactory.getLogger(InitBean.class);

    public static void init(Class<?> baseClass) {
        try {
            if (baseClass == null || baseClass.getPackage() == null || baseClass.getPackage().getName() == null) {
                return;
            }
            ClasspathPackageScanner scan = new ClasspathPackageScanner(baseClass.getPackage().getName());
            InitBean.initConfiguration(scan);
            InitBean.initWebSocket(scan);
            InitBean.initTest(scan);
            InitBean.initBean(scan);
            InitBean.initController(scan);
            InitBean.initHook(scan);
            InitBean.initFilter(scan);
            EventDispatcher.init(scan);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initConfiguration(PackageScanner scan) throws Exception {
        List<Class<?>> classs = scan.getAnnotationList(Configuration.class);
        for (Class<?> aClass : classs) {
            Method[] methods = aClass.getDeclaredMethods();
            Object o = aClass.newInstance();
            for (Field field : aClass.getDeclaredFields()) {
                InitBean.valuezr(field, o);
            }
            for (AccessibleObject accessibleObject : methods) {
                Bean bean = ((Method)accessibleObject).getAnnotation(Bean.class);
                if (bean == null) continue;
                try {
                    Object invoke = ((Method)accessibleObject).invoke(o, new Object[0]);
                    if (invoke != null) {
                        String value = bean.value();
                        if (value.trim().length() > 0) {
                            IocUtil.addBean(value, invoke);
                            continue;
                        }
                        IocUtil.addBean(invoke.getClass().getName(), invoke);
                        continue;
                    }
                    log.warn("{},\u65b9\u6cd5\u8fd4\u56de\u7a7a\u503c\uff0c\u4e0d\u8fdb\u5165\u5bb9\u5668", (Object)((Method)accessibleObject).getName());
                }
                catch (Exception e) {
                    log.warn("{},\u65b9\u6cd5\u4e0d\u80fd\u6709\u5165\u53c2", (Object)((Method)accessibleObject).getName());
                }
            }
        }
    }

    private static void initWebSocket(PackageScanner scan) throws Exception {
        List<Class<?>> classs = scan.getAnnotationList(WebSocket.class);
        for (Class<?> aClass : classs) {
            WebSocket annotation = aClass.getAnnotation(WebSocket.class);
            IocUtil.addBean(aClass.getName(), aClass.newInstance());
            WebSocketServerHandler.WebSocketRouter.put(annotation.value(), aClass.getName());
        }
    }

    private static void initTest(PackageScanner scan) throws Exception {
        try {
            Class<?> aClass1 = InitBean.class.getClassLoader().loadClass("org.junit.runner.RunWith");
            List<Class<?>> classs = scan.getAnnotationList(aClass1);
            for (Class<?> aClass : classs) {
                IocUtil.addBean(aClass.getName(), aClass.newInstance());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initBean(PackageScanner scan) throws Exception {
        List<Class<?>> classs = scan.getAnnotationList(Bean.class);
        for (Class<?> aClass : classs) {
            if (GlobalException.class.isAssignableFrom(aClass)) {
                IocUtil.addBean(GlobalException.class.getName(), aClass.newInstance());
                continue;
            }
            if (InitRunner.class.isAssignableFrom(aClass)) {
                IocUtil.addBean(InitRunner.class.getName(), aClass.newInstance());
                continue;
            }
            if (PermissionAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addBean(PermissionAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (TrackAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addBean(TrackAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (AnnotationAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addBean(AnnotationAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            Bean annotation = aClass.getAnnotation(Bean.class);
            if (annotation.value().trim().length() > 0) {
                IocUtil.addBean(annotation.value(), aClass.newInstance());
            } else {
                IocUtil.addBean(aClass.getName(), aClass.newInstance());
            }
            Method[] methods = aClass.getDeclaredMethods();
            RpcService rpcService = aClass.getAnnotation(RpcService.class);
            if (rpcService != null) {
                ClientData clientData = new ClientData();
                clientData.setClassName(aClass.getName());
                clientData.setMethods(methods);
                if (rpcService.value().trim().length() > 0) {
                    clientData.setAClass(rpcService.value());
                    CloudManager.add(rpcService.value(), clientData);
                    IocUtil.addBean(rpcService.value(), aClass.newInstance());
                } else {
                    Class<?>[] interfaces = aClass.getInterfaces();
                    if (interfaces != null && interfaces.length > 0) {
                        clientData.setAClass(interfaces[0].getName());
                        IocUtil.addBean(interfaces[0].getName(), aClass.newInstance());
                        CloudManager.add(interfaces[0].getName(), clientData);
                    } else {
                        log.error("RPC\u6ca1\u6709\u5b9e\u73b0\u4efb\u4f55\u63a5\u53e3\uff0c\u9884\u8ba1\u8c03\u7528\u8fc7\u7a0b\u4f1a\u51fa\u73b0\u95ee\u9898:{}", (Object)aClass.getSimpleName());
                    }
                }
            }
            for (Method method : methods) {
                Task task = method.getAnnotation(Task.class);
                if (task == null) continue;
                if (annotation.value().trim().length() > 0) {
                    TaskManager.initTask(task.name(), task.time(), annotation.value(), method, new Object[0]);
                    continue;
                }
                TaskManager.initTask(task.name(), task.time(), aClass.getName(), method, new Object[0]);
            }
        }
    }

    private static void initController(PackageScanner scan) throws Exception {
        List<Class<?>> classs = scan.getAnnotationList(Controller.class);
        for (Class<?> aClass : classs) {
            Method[] methods;
            for (Method method : methods = aClass.getDeclaredMethods()) {
                String[] requestMethod;
                Class[] classes;
                Controller controller = aClass.getAnnotation(Controller.class);
                String controllerPath = controller.value().trim();
                ParameterUtil.addParam(aClass, method);
                for (Class aClass1 : classes = new Class[]{GET.class, POST.class, HEAD.class, PUT.class, PATCH.class, DELETE.class, OPTIONS.class, CONNECT.class, TRACE.class}) {
                    Object annotation = method.getAnnotation(aClass1);
                    if (annotation == null) continue;
                    Method value = aClass1.getMethod("value", new Class[0]);
                    String path = controllerPath + value.invoke(annotation, new Object[0]).toString();
                    RouterInfo routerInfo = new RouterInfo();
                    method.setAccessible(true);
                    routerInfo.setMethod(method);
                    routerInfo.setAClass(aClass);
                    routerInfo.setUrl(path);
                    routerInfo.setReqMethodName(HttpMethod.valueOf((String)aClass1.getSimpleName()));
                    RouterManager.addRouter(routerInfo);
                    Sign sign = method.getAnnotation(Sign.class);
                    RequiresRoles requiresRoles = method.getAnnotation(RequiresRoles.class);
                    RequiresPermissions requiresPermissions = method.getAnnotation(RequiresPermissions.class);
                    if (sign == null && requiresRoles == null && requiresPermissions == null) continue;
                    RouterPermission routerPermission = new RouterPermission();
                    routerPermission.setUrl(path);
                    routerPermission.setReqMethodName(HttpMethod.valueOf((String)aClass1.getSimpleName()));
                    routerPermission.setSign(sign);
                    routerPermission.setRequiresRoles(requiresRoles);
                    routerPermission.setRequiresPermissions(requiresPermissions);
                    routerPermission.setControllerPackageName(aClass.getName());
                    routerPermission.setControllerName(controller.name().trim());
                    RouterManager.addPermission(routerPermission);
                }
                RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
                if (requestMapping == null) continue;
                RequestMethod[] requestMethods = requestMapping.method();
                if (requestMethods == null || requestMethods.length == 0) {
                    requestMethod = RequestMethod.getRequestMethodAll();
                } else {
                    String[] rm = new String[requestMethods.length];
                    for (int i = 0; i < requestMethods.length; ++i) {
                        rm[i] = requestMethods[i].name();
                    }
                    requestMethod = rm;
                }
                for (String s : requestMethod) {
                    String path = controllerPath + requestMapping.value();
                    RouterInfo routerInfo = new RouterInfo();
                    method.setAccessible(true);
                    routerInfo.setMethod(method);
                    routerInfo.setUrl(path);
                    routerInfo.setAClass(aClass);
                    routerInfo.setReqMethodName(HttpMethod.valueOf((String)s));
                    RouterManager.addRouter(routerInfo);
                    Sign sign = method.getAnnotation(Sign.class);
                    RequiresRoles requiresRoles = method.getAnnotation(RequiresRoles.class);
                    RequiresPermissions requiresPermissions = method.getAnnotation(RequiresPermissions.class);
                    if (sign == null && requiresRoles == null && requiresPermissions == null) continue;
                    RouterPermission routerPermission = new RouterPermission();
                    routerPermission.setUrl(path);
                    routerPermission.setReqMethodName(HttpMethod.valueOf((String)s));
                    routerPermission.setSign(sign);
                    routerPermission.setRequiresRoles(requiresRoles);
                    routerPermission.setRequiresPermissions(requiresPermissions);
                    routerPermission.setControllerPackageName(aClass.getName());
                    routerPermission.setControllerName(controller.name().trim());
                    RouterManager.addPermission(routerPermission);
                }
            }
            IocUtil.addBean(aClass.getName(), aClass.newInstance());
        }
    }

    private static void initFilter(PackageScanner scan) throws Exception {
        List<Class<?>> classes = scan.getAnnotationList(Filter.class);
        HashMap map = new HashMap();
        int tempMax = 0;
        for (Class<?> clazz : classes) {
            Filter handlerAnno = clazz.getAnnotation(Filter.class);
            if (handlerAnno == null) continue;
            log.info("{}\u4f18\u5148\u7ea7\uff1a{}", (Object)clazz.getCanonicalName(), (Object)handlerAnno.value());
            FilterAdapter obj = null;
            try {
                obj = (FilterAdapter)clazz.newInstance();
            }
            catch (Exception e) {
                log.error("\u521d\u59cb\u5316 {} \u9519\u8bef:{}", (Object)clazz.getSimpleName(), (Object)e);
                continue;
            }
            if (obj == null) continue;
            if (map.containsKey(handlerAnno.value())) {
                throw new RuntimeException("\u521d\u59cb\u5316\u63d2\u4ef6\u51fa\u73b0\u5f02\u5e38\uff0c\u987a\u5e8f\u51b2\u7a81:" + handlerAnno.value());
            }
            HashMap<String, FilterAdapter> filterMap = new HashMap<String, FilterAdapter>();
            filterMap.put(clazz.getName(), obj);
            map.put(handlerAnno.value(), filterMap);
            if (handlerAnno.value() <= tempMax) continue;
            tempMax = handlerAnno.value();
        }
        for (int i = 0; i <= tempMax; ++i) {
            if (!map.containsKey(i)) continue;
            Map filterMap = (Map)map.get(i);
            FilterChain.filtersIoc.add(filterMap);
        }
    }

    private static void initHook(PackageScanner scan) throws Exception {
        JavassistProxyFactory javassistProxyFactory = new JavassistProxyFactory();
        List<Class<?>> classs = scan.getAnnotationList(Hook.class);
        for (Class<?> aClass : classs) {
            Hook hook = aClass.getAnnotation(Hook.class);
            Class value = hook.value();
            String method = hook.method();
            Object newProxyInstance = javassistProxyFactory.newProxyInstance(value, aClass.getName(), method);
            IocUtil.addBean(aClass.getName(), aClass.newInstance());
            IocUtil.addBean(value.getName(), newProxyInstance);
        }
    }

    public static void injection() {
        Map<String, Object> all = IocUtil.getAll();
        all.forEach((k, v) -> {
            Field[] declaredFields = v.getClass().getDeclaredFields();
            InitBean.autoZr(declaredFields, v);
            Field[] declaredFields1 = v.getClass().getSuperclass().getDeclaredFields();
            InitBean.autoZr(declaredFields1, v);
        });
        List<Map<String, FilterAdapter>> filtersIoc = FilterChain.filtersIoc;
        filtersIoc.forEach(v -> {
            String next = (String)v.keySet().iterator().next();
            FilterAdapter filterAdapter = (FilterAdapter)v.get(next);
            Field[] declaredFields = filterAdapter.getClass().getDeclaredFields();
            InitBean.autoZr(declaredFields, filterAdapter);
            Field[] declaredFields1 = filterAdapter.getClass().getSuperclass().getDeclaredFields();
            InitBean.autoZr(declaredFields1, filterAdapter);
        });
    }

    private static void autoZr(Field[] declaredFields1, Object v) {
        for (Field field : declaredFields1) {
            InitBean.valuezr(field, v);
            InitBean.zr(field, v);
            InitBean.rpczr(field, v);
        }
    }

    public static void BeetlSqlinit() {
        HashMap sqlManagers = new HashMap();
        Map<String, Object> all1 = IocUtil.getAll();
        all1.forEach((k, v) -> {
            if ("org.beetl.sql.core.SQLManager".equals(v.getClass().getName())) {
                sqlManagers.put(k, v);
            }
        });
        if (sqlManagers == null) {
            return;
        }
        Map<String, Object> all = IocUtil.getAll();
        all.forEach((k, v) -> {
            Field[] declaredFields;
            for (Field declaredField : declaredFields = v.getClass().getDeclaredFields()) {
                InitBean.beetlsqlzr(declaredField, v, sqlManagers);
            }
        });
        List<Map<String, FilterAdapter>> filtersIoc = FilterChain.filtersIoc;
        filtersIoc.forEach(v -> {
            Field[] declaredFields;
            String next = (String)v.keySet().iterator().next();
            FilterAdapter filterAdapter = (FilterAdapter)v.get(next);
            for (Field declaredField : declaredFields = filterAdapter.getClass().getDeclaredFields()) {
                InitBean.beetlsqlzr(declaredField, filterAdapter, sqlManagers);
            }
        });
    }

    private static void rpczr(Field declaredField, Object v) {
        Resource annotation = declaredField.getAnnotation(Resource.class);
        if (annotation != null) {
            try {
                declaredField.setAccessible(true);
                Object proxy = CloudProxy.getProxy(declaredField.getType(), annotation);
                declaredField.set(v, proxy);
                log.info("{}----->{}\uff1a\u88c5\u914d\u5b8c\u6210\uff0cRpc\u88c5\u914d", (Object)proxy.getClass().getSimpleName(), (Object)v.getClass().getSimpleName());
            }
            catch (Exception e) {
                log.error("{}----->{}\uff1a\u88c5\u914d\u9519\u8bef:RPC\u4ee3\u7406\u751f\u6210\u5931\u8d25", (Object)v.getClass().getSimpleName(), (Object)v.getClass().getSimpleName());
            }
        }
    }

    private static void valuezr(Field declaredField, Object v) {
        Value annotation = declaredField.getAnnotation(Value.class);
        if (annotation != null) {
            try {
                declaredField.setAccessible(true);
                PropUtil instance = PropUtil.getInstance();
                String s = instance.get(annotation.value());
                Object convert = ParameterUtil.convert(declaredField, s);
                declaredField.set(v, convert);
            }
            catch (Exception e) {
                log.error("{}----->{}\uff1a@Value\u88c5\u914d\u9519\u8bef", (Object)v.getClass().getSimpleName(), (Object)v.getClass().getSimpleName());
            }
        }
    }

    private static void zr(Field declaredField, Object v) {
        Autowired annotation = declaredField.getAnnotation(Autowired.class);
        if (annotation != null) {
            String findMsg;
            Object bean;
            declaredField.setAccessible(true);
            if (annotation.value().trim().length() > 0) {
                bean = IocUtil.getBean(annotation.value());
                findMsg = "\u6309\u81ea\u5b9a\u4e49\u540d\u5b57\u88c5\u914d\uff0c" + declaredField.getType().getSimpleName();
            } else {
                findMsg = "\u6309\u7c7b\u578b\u88c5\u914d\uff0c" + declaredField.getType().getSimpleName();
                bean = IocUtil.getBean(declaredField.getType());
            }
            if (bean == null) {
                Map<String, Object> all = IocUtil.getAll();
                ArrayList allClassByInterface = new ArrayList();
                all.forEach((a, b) -> {
                    if (declaredField.getType().isAssignableFrom(b.getClass())) {
                        allClassByInterface.add(b.getClass());
                    }
                });
                if (allClassByInterface.size() > 0) {
                    if (allClassByInterface.size() > 1) {
                        log.warn("\u88c5\u914d\u8b66\u544a\uff0c\u5b58\u5728\u591a\u4e2a\u5b50\u7c7b\uff0c\u5efa\u8bae\u901a\u8fc7Bean\u540d\u5b57\u88c5\u914d\uff0c\u907f\u514d\u88c5\u914d\u9519\u8bef");
                    }
                    bean = IocUtil.getBean((Class)allClassByInterface.get(0));
                    findMsg = "\u6309\u5b50\u7c7b\u88c5\u914d\uff0c" + declaredField.getType().getSimpleName();
                } else {
                    BeetlSQL beetlSQL = declaredField.getType().getAnnotation(BeetlSQL.class);
                    if (beetlSQL != null) {
                        return;
                    }
                    log.error("\u88c5\u914d\u9519\u8bef:\u5bb9\u5668\u4e2d\u672a\u627e\u5230\u5bf9\u5e94\u7684Bean\u5bf9\u8c61\u88c5\u5907\u914d,\u67e5\u627e\u8bf4\u660e\uff1a{}", (Object)findMsg);
                    return;
                }
            }
            try {
                if (bean.getClass().getName().contains(declaredField.getType().getName())) {
                    declaredField.set(v, bean);
                    log.info("{}----->{}\uff1a\u88c5\u914d\u5b8c\u6210\uff0c{}", new Object[]{bean.getClass().getSimpleName(), v.getClass().getSimpleName(), findMsg});
                } else if (declaredField.getType().isAssignableFrom(bean.getClass())) {
                    declaredField.set(v, bean);
                    log.info("{}----->{}\uff1a\u88c5\u914d\u5b8c\u6210\uff0c{}", new Object[]{bean.getClass().getSimpleName(), v.getClass().getSimpleName(), findMsg});
                } else {
                    log.error("{}----->{}\uff1a\u88c5\u914d\u9519\u8bef:\u7c7b\u578b\u4e0d\u5339\u914d", (Object)v.getClass().getSimpleName(), (Object)v.getClass().getSimpleName());
                }
            }
            catch (Exception e) {
                log.error("\u88c5\u914d\u9519\u8bef:{},{}", (Object)declaredField.getName(), (Object)e.getMessage());
            }
        }
    }

    private static void beetlsqlzr(Field declaredField, Object v, Map sqlManagers) {
        Autowired annotation = declaredField.getAnnotation(Autowired.class);
        if (annotation != null) {
            declaredField.setAccessible(true);
            BeetlSQL beetlSQL = declaredField.getType().getAnnotation(BeetlSQL.class);
            try {
                if (beetlSQL != null) {
                    Object sqlManager = beetlSQL.value().trim().length() == 0 ? sqlManagers.get("org.beetl.sql.core.SQLManager") : sqlManagers.get(beetlSQL.value());
                    if (sqlManager == null) {
                        throw new NullPointerException("\u7a7a\u6307\u9488\uff0csqlManager-bean\u5b58\u5728\uff0c\u4f46\u662fBeetlSQL\u7684\u6ce8\u89e3\u7684Value\u503c\uff08" + beetlSQL.value() + "\uff09 \u7c7b\u578b\u4e0d\u5339\u914d,\u8bf7\u68c0\u67e5\u914d\u7f6e\u7c7b\u7684Bean \u540d\u5b57\u548cBeetlSQL \u7684\u662f\u5426\u4e00\u81f4.");
                    }
                    Class<?> aClass = sqlManager.getClass();
                    Method getMapper = aClass.getMethod("getMapper", Class.class);
                    if (getMapper == null) {
                        return;
                    }
                    Object bean = getMapper.invoke(sqlManager, declaredField.getType());
                    if (declaredField.getType().isAssignableFrom(bean.getClass())) {
                        declaredField.set(v, bean);
                        log.info("{}----->{}\uff1a\u88c5\u914d\u5b8c\u6210\uff0c{}", new Object[]{bean.getClass().getSimpleName(), v.getClass().getSimpleName(), "BeetlSql\u6ce8\u5165"});
                    } else {
                        log.error("{}----->{}\uff1a\u88c5\u914d\u9519\u8bef:\u7c7b\u578b\u4e0d\u5339\u914d", (Object)v.getClass().getSimpleName(), (Object)v.getClass().getSimpleName());
                    }
                }
            }
            catch (Exception e) {
                log.error("\u88c5\u914d\u9519\u8bef:{}", (Object)e.getMessage());
            }
        }
    }
}

