/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.ioc.ref;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.AnnotationAdapter;
import top.hserver.core.interfaces.TrackAdapter;
import top.hserver.core.ioc.annotation.Auto;
import top.hserver.core.ioc.annotation.Track;
import top.hserver.core.server.util.ClassLoadUtil;

public class MemoryInitClass {
    private static final Logger log = LoggerFactory.getLogger(MemoryInitClass.class);
    public static final ConcurrentHashMap<String, Object> annMapMethod = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, Object> annMapObject = new ConcurrentHashMap();

    public static void init(Class clazz) {
        if (clazz == null || clazz.getPackage() == null || clazz.getPackage().getName() == null) {
            return;
        }
        try {
            List<Class<?>> classes = ClassLoadUtil.LoadClasses(clazz.getPackage().getName(), true, true);
            ClassPool cp = ClassPool.getDefault();
            for (Class<?> aClass : classes) {
                Method[] methods;
                CtClass cc = null;
                try {
                    methods = aClass.getMethods();
                }
                catch (NoClassDefFoundError error) {
                    continue;
                }
                block5: for (Method method : methods) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = method.getAnnotations()) {
                        for (Annotation annotation1 : annotation.annotationType().getAnnotations()) {
                            if (!annotation1.annotationType().getName().equals(Auto.class.getName())) continue;
                            cc = cp.get(aClass.getName());
                            cc.freeze();
                            cc.defrost();
                            if (!annotation.annotationType().getName().equals(Track.class.getName())) {
                                log.debug("\u81ea\u5b9a\u4e49\u6ce8\u89e3\uff1a{}", (Object)annotation.annotationType().getName());
                                MemoryInitClass.autoAnnotation(cc, cp, annotation.annotationType(), method);
                            }
                            if (!annotation.annotationType().getName().equals(Track.class.getName())) continue block5;
                            log.debug("\u88ab\u94fe\u8def\u8ddf\u8e2a\u7684\u7c7b\uff1a{}", (Object)aClass.getName());
                            MemoryInitClass.initTrack(cc, cp, method);
                            continue block5;
                        }
                    }
                }
                if (cc == null) continue;
                cc.toClass();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initTrack(CtClass cc, ClassPool cp, Method method) throws Exception {
        CtMethod[] methods;
        for (CtMethod declaredMethod : methods = cc.getMethods()) {
            Object annotation = declaredMethod.getAnnotation(Track.class);
            if (annotation == null) continue;
            String uuid = UUID.randomUUID().toString();
            annMapMethod.put(uuid, method);
            log.debug("\u88ab\u94fe\u8def\u8ddf\u8e2a\u7684\u65b9\u6cd5\uff1a{}", (Object)declaredMethod.getName());
            declaredMethod.addLocalVariable("begin_hserver", CtClass.longType);
            declaredMethod.addLocalVariable("end_hserver", CtClass.longType);
            declaredMethod.addLocalVariable("trackAdapter_hserver", cp.get(TrackAdapter.class.getCanonicalName()));
            declaredMethod.addLocalVariable("clazz_hserver", cp.get(Class.class.getCanonicalName()));
            declaredMethod.addLocalVariable("annMethodObj", cp.get(Method.class.getCanonicalName()));
            declaredMethod.insertBefore("begin_hserver=System.currentTimeMillis();");
            declaredMethod.insertBefore("annMethodObj = (java.lang.reflect.Method)top.hserver.core.ioc.ref.MemoryInitClass.annMapMethod.get(\"" + uuid + "\");");
            StringBuilder src = new StringBuilder();
            src.append("end_hserver=System.currentTimeMillis();");
            src.append("trackAdapter_hserver = top.hserver.core.ioc.IocUtil.getBean(top.hserver.core.interfaces.TrackAdapter.class);");
            if (!Modifier.isStatic(declaredMethod.getModifiers())) {
                src.append("clazz_hserver = this.getClass();");
            } else {
                src.append("clazz_hserver = " + cc.getName() + ".class;");
            }
            src.append("if (trackAdapter_hserver!=null)");
            src.append("{");
            src.append(" trackAdapter_hserver.track(clazz_hserver,annMethodObj,Thread.currentThread().getStackTrace(), begin_hserver,end_hserver);");
            src.append("}");
            src.append("else");
            src.append("{");
            src.append("System.out.println(\"\u8bf7\u5b9e\u73b0\uff0cTrackAdapter\u63a5\u53e3\uff0c\u5e76\u7528@Bean\u6807\u6ce8\");");
            src.append("}");
            declaredMethod.insertAfter(src.toString());
        }
    }

    private static void autoAnnotation(CtClass cc, ClassPool cp, Class c, Method method) throws Exception {
        CtMethod[] methods;
        for (CtMethod declaredMethod : methods = cc.getMethods()) {
            Object annotation = declaredMethod.getAnnotation(c);
            if (annotation == null) continue;
            String uuid = UUID.randomUUID().toString();
            annMapObject.put(uuid, annotation);
            annMapMethod.put(uuid, method);
            log.debug("\u88ab\u6ce8\u89e3\u7684\u65b9\u6cd5\uff1a{}", (Object)declaredMethod.getName());
            declaredMethod.addLocalVariable("annAdapter_hserver", cp.get(AnnotationAdapter.class.getCanonicalName()));
            declaredMethod.addLocalVariable("annObj", cp.get(Annotation.class.getCanonicalName()));
            declaredMethod.addLocalVariable("annMethod", cp.get(Method.class.getCanonicalName()));
            declaredMethod.addLocalVariable("clazz_hserver_x", cp.get(Class.class.getCanonicalName()));
            StringBuilder insertBefore = new StringBuilder();
            insertBefore.append("annAdapter_hserver = top.hserver.core.ioc.IocUtil.getBean(top.hserver.core.interfaces.AnnotationAdapter.class);");
            insertBefore.append("annObj = (java.lang.annotation.Annotation)top.hserver.core.ioc.ref.MemoryInitClass.annMapObject.get(\"" + uuid + "\");");
            insertBefore.append("annMethod = (java.lang.reflect.Method)top.hserver.core.ioc.ref.MemoryInitClass.annMapMethod.get(\"" + uuid + "\");");
            if (!Modifier.isStatic(declaredMethod.getModifiers())) {
                insertBefore.append("clazz_hserver_x = this.getClass();");
            } else {
                insertBefore.append("clazz_hserver_x = " + cc.getName() + ".class;");
            }
            insertBefore.append("if (annAdapter_hserver!=null)");
            insertBefore.append("{");
            insertBefore.append(" annAdapter_hserver.before(annObj,$args,clazz_hserver_x,annMethod);");
            insertBefore.append("}");
            insertBefore.append("else");
            insertBefore.append("{");
            insertBefore.append("System.out.println(\"\u8bf7\u5b9e\u73b0\uff0cAnnotationAdapter\u63a5\u53e3\uff0c\u5e76\u7528@Bean\u6807\u6ce8\");");
            insertBefore.append("}");
            declaredMethod.insertBefore(insertBefore.toString());
            StringBuilder insertAfter = new StringBuilder();
            insertAfter.append("if (annAdapter_hserver!=null)");
            insertAfter.append("{");
            insertAfter.append("annAdapter_hserver.after(annObj,$_,clazz_hserver_x,annMethod);");
            insertAfter.append("}");
            insertAfter.append("else");
            insertAfter.append("{");
            insertAfter.append("System.out.println(\"\u8bf7\u5b9e\u73b0\uff0cAnnotationAdapter\u63a5\u53e3\uff0c\u5e76\u7528@Bean\u6807\u6ce8\");");
            insertAfter.append("}");
            declaredMethod.insertAfter(insertAfter.toString());
        }
    }
}

