/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import top.hserver.core.server.context.Response;
import top.hserver.core.server.context.WebContext;
import top.hserver.core.server.exception.BusinessException;
import top.hserver.core.server.util.ByteBufUtil;

public class BuildResponse {
    public static FullHttpResponse buildStaticShowType(WebContext webContext) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)Objects.requireNonNull(ByteBufUtil.FileToByteBuf(webContext.getStaticFile().getInputStream()))));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(webContext.getStaticFile().getFileHead() + ";charset=UTF-8"));
        return response;
    }

    public static FullHttpResponse buildControllerDownloadType(WebContext webContext) {
        Response response1 = webContext.getResponse();
        DefaultFullHttpResponse response = response1.getFile() == null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)Objects.requireNonNull(ByteBufUtil.FileToByteBuf(response1.getInputStream())))) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)Objects.requireNonNull(ByteBufUtil.FileToByteBuf(response1.getFile()))));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/octet-stream;charset=UTF-8");
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)String.format("attachment; filename=\"%s\"", webContext.getResponse().getFileName()));
        return response;
    }

    public static FullHttpResponse buildHttpResponseData(WebContext webContext) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])webContext.getResponse().getJsonAndHtml().getBytes(StandardCharsets.UTF_8)));
        return response;
    }

    public static FullHttpResponse buildControllerResult(WebContext webContext) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])webContext.getResult().getBytes(StandardCharsets.UTF_8)));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain;charset=UTF-8");
        return response;
    }

    public static FullHttpResponse buildEnd(FullHttpResponse response, WebContext webContext) {
        response.headers().set((CharSequence)HttpHeaderNames.SERVER, (Object)"HServer");
        response.headers().set("HServer", (Object)"2.9.22");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        Map<String, String> headers = webContext.getResponse().getHeaders();
        headers.forEach((a, b) -> {
            response.headers().set(a, b);
            if (a.equals("location")) {
                response.setStatus(HttpResponseStatus.FOUND);
            }
        });
        webContext.stopStatistics(System.currentTimeMillis());
        return response;
    }

    public static FullHttpResponse buildError(Throwable e) {
        BusinessException cause = (BusinessException)e.getCause();
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf((int)cause.getHttpCode());
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus, Unpooled.wrappedBuffer((byte[])cause.getRespMsg().getBytes(StandardCharsets.UTF_8)));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain;charset=UTF-8");
        response.headers().set("HServer", (Object)"2.9.22");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        return response;
    }
}

