/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.Loader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoadUtil {
    private static final Logger log = LoggerFactory.getLogger(ClassLoadUtil.class);

    public static List<Class<?>> LoadClasses(String packageName, boolean recursive, boolean isJavassist) {
        ArrayList classes = new ArrayList();
        String packageDirName = packageName.replace('.', '/');
        try {
            ClassLoader classLoader = null;
            if (isJavassist) {
                ClassPool cp = ClassPool.getDefault();
                classLoader = new Loader(cp);
            } else {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            Enumeration<URL> dirs = classLoader.getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    ClassLoadUtil.findAndLoadClassesInPackageByFile(classLoader, packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    return entries;
                }
                catch (IOException iOException) {
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classes;
    }

    private static void findAndLoadClassesInPackageByFile(ClassLoader classLoader, String packageName, String packagePath, final boolean recursive, List<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassLoadUtil.findAndLoadClassesInPackageByFile(classLoader, packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(classLoader.loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

