/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import java.io.InputStream;
import java.util.Properties;

public class PropUtil {
    private static PropUtil propUtil;
    private String name = "/application.properties";

    public PropUtil() {
    }

    public PropUtil(String fileName) {
        this.name = fileName;
    }

    public static PropUtil getInstance() {
        if (propUtil != null) {
            return propUtil;
        }
        propUtil = new PropUtil();
        return propUtil;
    }

    public String get(String key) {
        String value = "";
        try (InputStream is = PropUtil.class.getResourceAsStream(this.name);){
            Properties p = new Properties();
            p.load(is);
            value = p.getProperty(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key.trim());
        if (this.isBlank(value)) {
            value = defaultValue;
        }
        return value.trim();
    }

    private boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

