/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.task;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.CancellationException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import top.hserver.core.interfaces.TaskJob;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.task.CronExecutorService;
import top.hserver.core.task.CronExpression;
import top.hserver.core.task.TaskManager;

public class ScheduledThreadPoolExecutorPro
extends ScheduledThreadPoolExecutor
implements CronExecutorService {
    ScheduledThreadPoolExecutorPro(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    @Override
    public ScheduledFuture<?> submit(CronExpression expression, String className, Method method, Object ... args) {
        Runnable scheduleTask = () -> {
            Date now = new Date();
            Date time = expression.getNextValidTimeAfter(now);
            try {
                while (time != null) {
                    while (now.before(time)) {
                        Thread.sleep(time.getTime() - now.getTime());
                        now = new Date();
                    }
                    time = expression.getNextValidTimeAfter(now);
                    if (!TaskManager.IS_OK.booleanValue()) continue;
                    try {
                        method.invoke(IocUtil.getBean(className), args);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (CancellationException | RejectedExecutionException e) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        return this.schedule(scheduleTask, 1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> submit(CronExpression expression, TaskJob taskJob, Object ... args) {
        Runnable scheduleTask = () -> {
            Date now = new Date();
            Date time = expression.getNextValidTimeAfter(now);
            try {
                while (time != null) {
                    while (now.before(time)) {
                        Thread.sleep(time.getTime() - now.getTime());
                        now = new Date();
                    }
                    time = expression.getNextValidTimeAfter(now);
                    if (!TaskManager.IS_OK.booleanValue()) continue;
                    try {
                        taskJob.exec(args);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (CancellationException | RejectedExecutionException e) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        };
        return this.schedule(scheduleTask, 1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> submit(Integer expression, String className, Method method, Object ... args) {
        Runnable scheduleTask = () -> {
            if (TaskManager.IS_OK.booleanValue()) {
                try {
                    method.invoke(IocUtil.getBean(className), args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        return this.scheduleAtFixedRate(scheduleTask, expression.intValue(), expression.intValue(), TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledFuture<?> submit(Integer expression, TaskJob taskJob, Object ... args) {
        Runnable scheduleTask = () -> {
            if (TaskManager.IS_OK.booleanValue()) {
                try {
                    taskJob.exec(args);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        return this.scheduleAtFixedRate(scheduleTask, expression.intValue(), expression.intValue(), TimeUnit.MILLISECONDS);
    }
}

