package top.hserver.core.ioc;

import java.util.Map;

public interface Ioc {

    Map<String, Object> getAll();

    void addBean(Object bean);

    void addBean(String name, Object bean);

    void remove(Class<?> type);

    void remove(String beanName);

    <T> T getBean(Class<T> type);

    Object getBean(String beanName);

    <T> T getBean(String beanName, Class<T> type);

    void clearAll();

    boolean exist(String beanName);

    boolean exist(Class<?> type);

}