/*
 * Decompiled with CFR 0.152.
 */
package top.hserver;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.InitRunner;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.ioc.ref.InitBean;
import top.hserver.core.ioc.ref.MemoryInitClass;
import top.hserver.core.log.HServerLogConfig;
import top.hserver.core.plugs.PlugsManager;
import top.hserver.core.properties.PropertiesInit;
import top.hserver.core.queue.QueueDispatcher;
import top.hserver.core.server.HServer;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.json.JsonAdapter;
import top.hserver.core.server.util.EnvironmentUtil;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.PackageUtil;
import top.hserver.core.task.TaskManager;

public class HServerApplication {
    private static final Logger log = LoggerFactory.getLogger(HServerApplication.class);
    public static Class mainClass;
    private static final PlugsManager PLUGS_MANAGER;

    public static void run(Class mainClass, Integer port, String ... args) {
        ConstConfig.PORTS = new Integer[]{port};
        HServerApplication.iocInit(mainClass);
        HServerApplication.startServer(args);
    }

    public static void run(Class mainClass, Integer[] ports, String ... args) {
        ConstConfig.PORTS = ports;
        HServerApplication.iocInit(mainClass);
        HServerApplication.startServer(args);
    }

    public static void run(Class mainClass, String ... args) {
        HServerApplication.iocInit(mainClass);
        HServerApplication.startServer(args);
    }

    public static void runTest(String testPackageName, Class clazz) {
        HServerApplication.iocInit(clazz, null, testPackageName);
        HServerApplication.initTestOk(null);
    }

    private static void startServer(String[] args) {
        try {
            new HServer(ConstConfig.PORTS, args).run();
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
    }

    private static void iocInit(Class mainClass) {
        HServerApplication.iocInit(null, mainClass, new String[0]);
    }

    private static synchronized void iocInit(Class clazz, Class mainClass, String ... packages) {
        Set<String> scanPackage;
        HServerApplication.mainClass = mainClass;
        try {
            EnvironmentUtil.init(clazz);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
            return;
        }
        HServerLogConfig.init();
        log.info("\u68c0\u67e5\u5305\u6587\u4ef6");
        if (mainClass == null) {
            scanPackage = PackageUtil.scanPackage();
            if (packages != null) {
                scanPackage.addAll(Arrays.asList(packages));
            }
        } else {
            scanPackage = new HashSet<String>();
            scanPackage.add(mainClass.getPackage().getName());
        }
        scanPackage.addAll(PLUGS_MANAGER.getPlugPackages());
        scanPackage.add(HServerApplication.class.getPackage().getName());
        log.info("\u521d\u59cb\u5316\u914d\u7f6e\u6587\u4ef6");
        PropertiesInit.configFile();
        log.info("\u521d\u59cb\u5316\u914d\u7f6e\u5b8c\u6210");
        log.info("Class\u52a8\u6001\u4fee\u6539\u5f00\u59cb...");
        MemoryInitClass.modifyNetty();
        if (ConstConfig.TRACK.booleanValue()) {
            MemoryInitClass.closeCache();
            for (String s : scanPackage) {
                MemoryInitClass.init(s);
            }
            if (ConstConfig.TRACK_EXT_PACKAGES != null && ConstConfig.TRACK_EXT_PACKAGES.length > 0) {
                for (String extPackage : ConstConfig.TRACK_EXT_PACKAGES) {
                    MemoryInitClass.init(extPackage);
                }
            }
            MemoryInitClass.closeCache();
        }
        log.info("Class\u52a8\u6001\u4fee\u6539\u5b8c\u6210");
        log.info("HServer \u542f\u52a8\u4e2d....");
        log.info("Package \u626b\u63cf\u4e2d");
        PLUGS_MANAGER.startIocInit();
        InitBean.init(scanPackage);
        PLUGS_MANAGER.iocInitEnd();
        log.info("IOC \u88c5\u914d\u4e2d");
        PLUGS_MANAGER.startInjection();
        InitBean.injection();
        PLUGS_MANAGER.injectionEnd();
        log.info("IOC \u5168\u90e8\u88c5\u914d\u5b8c\u6210");
    }

    private static void initTestOk(String[] args) {
        TaskManager.IS_OK = true;
        QueueDispatcher.startTaskThread();
        List<InitRunner> listBean = IocUtil.getListBean(InitRunner.class);
        if (listBean != null) {
            for (InitRunner initRunner : listBean) {
                initRunner.init(args);
            }
        }
    }

    public static void setJson(JsonAdapter jsonAdapter) {
        ConstConfig.JSONADAPTER = jsonAdapter;
    }

    static {
        PLUGS_MANAGER = new PlugsManager();
    }
}

