/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.ioc.ref;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.ioc.annotation.Configuration;
import top.hserver.core.ioc.annotation.ConfigurationProperties;
import top.hserver.core.ioc.annotation.Controller;
import top.hserver.core.ioc.annotation.Hook;
import top.hserver.core.ioc.annotation.WebSocket;
import top.hserver.core.ioc.annotation.queue.QueueListener;
import top.hserver.core.ioc.ref.PackageScanner;
import top.hserver.core.server.util.ClassLoadUtil;

public class ClasspathPackageScanner
implements PackageScanner {
    private Map<Class, Set<Class<?>>> annotationClass = new HashMap();

    public ClasspathPackageScanner(Set<String> packageNames) {
        packageNames.forEach(basePackage -> {
            List<Class<?>> classes = ClassLoadUtil.LoadClasses(basePackage, false);
            for (Class<?> aClass : classes) {
                if (aClass.getAnnotation(Bean.class) != null) {
                    this.add(aClass, Bean.class);
                }
                if (aClass.getAnnotation(WebSocket.class) != null) {
                    this.add(aClass, WebSocket.class);
                }
                if (aClass.getAnnotation(Configuration.class) != null) {
                    this.add(aClass, Configuration.class);
                }
                if (aClass.getAnnotation(Controller.class) != null) {
                    this.add(aClass, Controller.class);
                }
                if (aClass.getAnnotation(Hook.class) != null) {
                    this.add(aClass, Hook.class);
                }
                if (aClass.getAnnotation(QueueListener.class) != null) {
                    this.add(aClass, QueueListener.class);
                }
                if (aClass.getAnnotation(ConfigurationProperties.class) != null) {
                    this.add(aClass, ConfigurationProperties.class);
                }
                try {
                    Class<?> aClass1 = this.getClass().getClassLoader().loadClass("org.junit.runner.RunWith");
                    if (aClass.getAnnotation(aClass1) == null) continue;
                    this.add(aClass, aClass1);
                }
                catch (Exception exception) {}
            }
        });
    }

    private <A extends Annotation> void add(Class<?> aClass, Class<A> annotation) {
        Set<Class<?>> classes = this.annotationClass.get(annotation);
        if (classes == null) {
            classes = new HashSet();
            classes.add(aClass);
            this.annotationClass.put(annotation, classes);
        } else {
            classes.add(aClass);
            this.annotationClass.put(annotation, classes);
        }
    }

    @Override
    public <A extends Annotation> Set<Class<?>> getAnnotationList(Class<A> annotation) throws IOException {
        Set<Class<?>> classes = this.annotationClass.get(annotation);
        if (classes == null) {
            return new HashSet();
        }
        return classes;
    }
}

