/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.ioc.ref;

import io.netty.handler.codec.http.HttpMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.ProxyObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.FilterAdapter;
import top.hserver.core.interfaces.GlobalException;
import top.hserver.core.interfaces.HumAdapter;
import top.hserver.core.interfaces.InitRunner;
import top.hserver.core.interfaces.LimitAdapter;
import top.hserver.core.interfaces.LogAdapter;
import top.hserver.core.interfaces.MqttAdapter;
import top.hserver.core.interfaces.PermissionAdapter;
import top.hserver.core.interfaces.ProtocolDispatcherAdapter;
import top.hserver.core.interfaces.ResponseAdapter;
import top.hserver.core.interfaces.ServerCloseAdapter;
import top.hserver.core.interfaces.TrackAdapter;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.ioc.annotation.Autowired;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.ioc.annotation.CONNECT;
import top.hserver.core.ioc.annotation.Configuration;
import top.hserver.core.ioc.annotation.ConfigurationProperties;
import top.hserver.core.ioc.annotation.Controller;
import top.hserver.core.ioc.annotation.DELETE;
import top.hserver.core.ioc.annotation.GET;
import top.hserver.core.ioc.annotation.HEAD;
import top.hserver.core.ioc.annotation.Hook;
import top.hserver.core.ioc.annotation.OPTIONS;
import top.hserver.core.ioc.annotation.Order;
import top.hserver.core.ioc.annotation.PATCH;
import top.hserver.core.ioc.annotation.POST;
import top.hserver.core.ioc.annotation.PUT;
import top.hserver.core.ioc.annotation.Request;
import top.hserver.core.ioc.annotation.RequestMapping;
import top.hserver.core.ioc.annotation.RequestMethod;
import top.hserver.core.ioc.annotation.RequiresPermissions;
import top.hserver.core.ioc.annotation.RequiresRoles;
import top.hserver.core.ioc.annotation.Sign;
import top.hserver.core.ioc.annotation.TRACE;
import top.hserver.core.ioc.annotation.Task;
import top.hserver.core.ioc.annotation.Value;
import top.hserver.core.ioc.annotation.WebSocket;
import top.hserver.core.ioc.ref.ClasspathPackageScanner;
import top.hserver.core.ioc.ref.HookCheck;
import top.hserver.core.ioc.ref.PackageScanner;
import top.hserver.core.proxy.HookProxyFactory;
import top.hserver.core.queue.QueueDispatcher;
import top.hserver.core.server.handlers.WebSocketServerHandler;
import top.hserver.core.server.router.RouterInfo;
import top.hserver.core.server.router.RouterManager;
import top.hserver.core.server.router.RouterPermission;
import top.hserver.core.server.util.ClassLoadUtil;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.ParameterUtil;
import top.hserver.core.server.util.PropUtil;
import top.hserver.core.task.TaskManager;

public class InitBean {
    private static final Logger log = LoggerFactory.getLogger(InitBean.class);

    private static void sortOrder() {
        Class[] order;
        for (Class aClass : order = new Class[]{LimitAdapter.class, FilterAdapter.class, GlobalException.class, InitRunner.class, HumAdapter.class, ResponseAdapter.class, LogAdapter.class, ProtocolDispatcherAdapter.class, ServerCloseAdapter.class}) {
            List listBean = IocUtil.getListBean(aClass);
            ArrayList newObjectList = new ArrayList();
            if (listBean == null || listBean.size() <= 1) continue;
            int temp = 1;
            for (Object o : listBean) {
                Order annotation = o.getClass().getAnnotation(Order.class);
                if (annotation != null) {
                    if (temp > annotation.value()) {
                        newObjectList.add(0, o);
                        temp = annotation.value();
                        continue;
                    }
                    newObjectList.add(o);
                    temp = annotation.value();
                    continue;
                }
                newObjectList.add(o);
            }
            IocUtil.remove(aClass);
            IocUtil.addBean(aClass.getName(), newObjectList);
        }
    }

    public static void init(Set<String> packageNames) {
        if (packageNames == null) {
            return;
        }
        ClasspathPackageScanner scan = new ClasspathPackageScanner(packageNames);
        try {
            InitBean.initConfigurationProperties(scan);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
        try {
            InitBean.initConfiguration(scan);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
        try {
            InitBean.initWebSocket(scan);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
        try {
            InitBean.initTest(scan);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
        try {
            InitBean.initBean(scan);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
        try {
            InitBean.initController(scan);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
        try {
            InitBean.initHook(scan, packageNames);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
        try {
            QueueDispatcher.init(scan);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
        InitBean.sortOrder();
    }

    private static void initConfigurationProperties(PackageScanner scanner) throws Exception {
        Set<Class<?>> clasps = scanner.getAnnotationList(ConfigurationProperties.class);
        for (Class<?> clasp : clasps) {
            String value = clasp.getAnnotation(ConfigurationProperties.class).prefix();
            if (value.trim().length() == 0) {
                value = null;
            }
            Object o = clasp.newInstance();
            for (Field field : clasp.getDeclaredFields()) {
                try {
                    PropUtil instance = PropUtil.getInstance();
                    String s = instance.get(value == null ? field.getName() : value + "." + field.getName(), null);
                    Object convert = ParameterUtil.convert(field.getType(), s);
                    if (convert == null) continue;
                    field.setAccessible(true);
                    field.set(o, convert);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
            }
            IocUtil.addBean(clasp.getName(), o);
        }
    }

    private static void initConfiguration(PackageScanner scan) throws Exception {
        Set<Class<?>> clasps = scan.getAnnotationList(Configuration.class);
        for (Class<?> aClass : clasps) {
            Method[] methods = aClass.getDeclaredMethods();
            Object o = aClass.newInstance();
            for (Field field : aClass.getDeclaredFields()) {
                InitBean.valuezr(field, o);
                InitBean.zr(field, o);
            }
            for (AccessibleObject accessibleObject : methods) {
                Bean bean = ((Method)accessibleObject).getAnnotation(Bean.class);
                if (bean == null) continue;
                try {
                    if (((Method)accessibleObject).getParameterTypes().length > 0) {
                        log.warn("\u7c7b\uff1a{} \u65b9\u6cd5\uff1a{}\uff0c\u65b9\u6cd5\u4e0d\u80fd\u6709\u5165\u53c2", (Object)aClass.getName(), (Object)((Method)accessibleObject).getName());
                        continue;
                    }
                    ((Method)accessibleObject).setAccessible(true);
                    Object invoke = ((Method)accessibleObject).invoke(o, new Object[0]);
                    if (invoke != null) {
                        String value = bean.value();
                        if (value.trim().length() > 0) {
                            IocUtil.addBean(value, invoke);
                            continue;
                        }
                        IocUtil.addBean(invoke.getClass().getName(), invoke);
                        continue;
                    }
                    log.warn("{},\u65b9\u6cd5\u8fd4\u56de\u7a7a\u503c\uff0c\u4e0d\u8fdb\u5165\u5bb9\u5668", (Object)((Method)accessibleObject).getName());
                }
                catch (Exception e) {
                    log.warn("\u7c7b\uff1a{} \u65b9\u6cd5\uff1a{}\uff0c\u6267\u884c\u5f02\u5e38\uff0c", (Object)aClass.getName(), (Object)((Method)accessibleObject).getName());
                    log.warn(ExceptionUtil.getMessage(e));
                }
            }
        }
    }

    private static void initWebSocket(PackageScanner scan) throws Exception {
        Set<Class<?>> clasps = scan.getAnnotationList(WebSocket.class);
        for (Class<?> aClass : clasps) {
            WebSocket annotation = aClass.getAnnotation(WebSocket.class);
            IocUtil.addBean(aClass.getName(), aClass.newInstance());
            WebSocketServerHandler.WEB_SOCKET_ROUTER.put(annotation.value(), aClass.getName());
        }
    }

    private static void initTest(PackageScanner scan) throws Exception {
        try {
            Class<?> aClass1 = InitBean.class.getClassLoader().loadClass("org.junit.runner.RunWith");
            Set<Class<?>> clasps = scan.getAnnotationList(aClass1);
            for (Class<?> aClass : clasps) {
                IocUtil.addBean(aClass.getName(), aClass.newInstance());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void initBean(PackageScanner scan) throws Exception {
        Set<Class<?>> clasps = scan.getAnnotationList(Bean.class);
        for (Class<?> aClass : clasps) {
            Method[] methods;
            if (GlobalException.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(GlobalException.class.getName(), aClass.newInstance());
                continue;
            }
            if (InitRunner.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(InitRunner.class.getName(), aClass.newInstance());
                continue;
            }
            if (HumAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(HumAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (ServerCloseAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(ServerCloseAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (LogAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(LogAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (PermissionAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(PermissionAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (TrackAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(TrackAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (FilterAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(FilterAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (LimitAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(LimitAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (ResponseAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(ResponseAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (ProtocolDispatcherAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addListBean(ProtocolDispatcherAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            if (MqttAdapter.class.isAssignableFrom(aClass)) {
                IocUtil.addBean(MqttAdapter.class.getName(), aClass.newInstance());
                continue;
            }
            Bean annotation = aClass.getAnnotation(Bean.class);
            if (annotation.value().trim().length() > 0) {
                IocUtil.addBean(annotation.value(), aClass.newInstance());
            } else {
                IocUtil.addBean(aClass.getName(), aClass.newInstance());
            }
            for (Method method : methods = aClass.getDeclaredMethods()) {
                Task task = method.getAnnotation(Task.class);
                if (task == null) continue;
                if (annotation.value().trim().length() > 0) {
                    TaskManager.initTask(task.name(), task.time(), annotation.value(), method, new Object[0]);
                    continue;
                }
                TaskManager.initTask(task.name(), task.time(), aClass.getName(), method, new Object[0]);
            }
        }
    }

    private static void initController(PackageScanner scan) throws Exception {
        Set<Class<?>> clasps = scan.getAnnotationList(Controller.class);
        for (Class<?> aClass : clasps) {
            Method[] methods;
            for (Method method : methods = aClass.getDeclaredMethods()) {
                String[] requestMethod;
                Class[] classes;
                Controller controller = aClass.getAnnotation(Controller.class);
                String controllerPath = controller.value().trim();
                Annotation[] annotations = method.getAnnotations();
                if (Arrays.stream(annotations).noneMatch(annotation -> annotation.annotationType().getAnnotation(Request.class) != null)) continue;
                try {
                    ParameterUtil.addParam(aClass, method);
                }
                catch (Exception ignored) {
                    continue;
                }
                for (Class aClass1 : classes = new Class[]{GET.class, POST.class, HEAD.class, PUT.class, PATCH.class, DELETE.class, OPTIONS.class, CONNECT.class, TRACE.class}) {
                    Object annotation2 = method.getAnnotation(aClass1);
                    if (annotation2 == null) continue;
                    Method value = aClass1.getMethod("value", new Class[0]);
                    value.setAccessible(true);
                    String path = controllerPath + value.invoke(annotation2, new Object[0]).toString();
                    RouterInfo routerInfo = new RouterInfo();
                    method.setAccessible(true);
                    routerInfo.setMethod(method);
                    routerInfo.setaClass(aClass);
                    routerInfo.setUrl(path);
                    routerInfo.setReqMethodName(HttpMethod.valueOf((String)aClass1.getSimpleName()));
                    RouterManager.addRouter(routerInfo);
                    Sign sign = method.getAnnotation(Sign.class);
                    RequiresRoles requiresRoles = method.getAnnotation(RequiresRoles.class);
                    RequiresPermissions requiresPermissions = method.getAnnotation(RequiresPermissions.class);
                    if (sign == null && requiresRoles == null && requiresPermissions == null) continue;
                    RouterPermission routerPermission = new RouterPermission();
                    routerPermission.setUrl(path);
                    routerPermission.setReqMethodName(HttpMethod.valueOf((String)aClass1.getSimpleName()));
                    routerPermission.setSign(sign);
                    routerPermission.setRequiresRoles(requiresRoles);
                    routerPermission.setRequiresPermissions(requiresPermissions);
                    routerPermission.setControllerPackageName(aClass.getName());
                    routerPermission.setControllerName(controller.name().trim());
                    RouterManager.addPermission(routerPermission);
                }
                RequestMapping requestMapping = method.getAnnotation(RequestMapping.class);
                if (requestMapping == null) continue;
                RequestMethod[] requestMethods = requestMapping.method();
                if (requestMethods.length == 0) {
                    requestMethod = RequestMethod.getRequestMethodAll();
                } else {
                    String[] rm = new String[requestMethods.length];
                    for (int i = 0; i < requestMethods.length; ++i) {
                        rm[i] = requestMethods[i].name();
                    }
                    requestMethod = rm;
                }
                for (String s : requestMethod) {
                    String path = controllerPath + requestMapping.value();
                    RouterInfo routerInfo = new RouterInfo();
                    method.setAccessible(true);
                    routerInfo.setMethod(method);
                    routerInfo.setUrl(path);
                    routerInfo.setaClass(aClass);
                    routerInfo.setReqMethodName(HttpMethod.valueOf((String)s));
                    RouterManager.addRouter(routerInfo);
                    Sign sign = method.getAnnotation(Sign.class);
                    RequiresRoles requiresRoles = method.getAnnotation(RequiresRoles.class);
                    RequiresPermissions requiresPermissions = method.getAnnotation(RequiresPermissions.class);
                    if (sign == null && requiresRoles == null && requiresPermissions == null) continue;
                    RouterPermission routerPermission = new RouterPermission();
                    routerPermission.setUrl(path);
                    routerPermission.setReqMethodName(HttpMethod.valueOf((String)s));
                    routerPermission.setSign(sign);
                    routerPermission.setRequiresRoles(requiresRoles);
                    routerPermission.setRequiresPermissions(requiresPermissions);
                    routerPermission.setControllerPackageName(aClass.getName());
                    routerPermission.setControllerName(controller.name().trim());
                    RouterManager.addPermission(routerPermission);
                }
            }
            IocUtil.addBean(aClass.getName(), aClass.newInstance());
        }
    }

    private static HookCheck checkHook(Class aClass1) {
        String iocName = null;
        boolean isList = false;
        Map<String, Object> allIoc = IocUtil.getAll();
        block0: for (String tempIocName : allIoc.keySet()) {
            Object v = allIoc.get(tempIocName);
            if (v instanceof List) {
                List v1 = (List)v;
                for (Object o : v1) {
                    if (!aClass1.isAssignableFrom(o.getClass())) continue;
                    iocName = tempIocName;
                    isList = true;
                    continue block0;
                }
                continue;
            }
            if (!aClass1.isAssignableFrom(v.getClass()) || ProxyObject.class.isAssignableFrom(v.getClass())) continue;
            iocName = tempIocName;
            break;
        }
        if (iocName == null) {
            return null;
        }
        return new HookCheck(iocName, isList);
    }

    private static void initHook(PackageScanner scan, Set<String> packages) throws Exception {
        HookProxyFactory hookProxyFactory = new HookProxyFactory();
        Set<Class<?>> clasps = scan.getAnnotationList(Hook.class);
        for (Class<?> aClass : clasps) {
            Class[] values;
            Hook hook = aClass.getAnnotation(Hook.class);
            for (Class value : values = hook.value()) {
                if (Annotation.class.isAssignableFrom(value)) {
                    for (String aPackage : packages) {
                        List<Class<?>> classes = ClassLoadUtil.LoadClasses(aPackage, false);
                        block5: for (Class<?> aClass1 : classes) {
                            try {
                                Method[] declaredMethods;
                                Object annotation = aClass1.getAnnotation(value);
                                if (annotation != null) {
                                    Object newProxyInstance = hookProxyFactory.newProxyInstance(aClass1, value.getName() + "HOOK");
                                    if (newProxyInstance == null) continue;
                                    IocUtil.addBean(newProxyInstance.getClass().getName(), newProxyInstance);
                                    HookCheck hookCheck = InitBean.checkHook(aClass1);
                                    if (hookCheck != null) {
                                        if (hookCheck.isList()) {
                                            IocUtil.addListBean(hookCheck.getIocName(), newProxyInstance);
                                            continue;
                                        }
                                        IocUtil.addBean(hookCheck.getIocName(), newProxyInstance);
                                        continue;
                                    }
                                    IocUtil.addBean(aClass1.getName(), newProxyInstance);
                                    continue;
                                }
                                for (Method declaredMethod : declaredMethods = aClass1.getDeclaredMethods()) {
                                    Object newProxyInstance;
                                    Object annotation1 = declaredMethod.getAnnotation(value);
                                    if (annotation1 == null || (newProxyInstance = hookProxyFactory.newProxyInstance(aClass1, value.getName() + "HOOK")) == null) continue;
                                    IocUtil.addBean(newProxyInstance.getClass().getName(), newProxyInstance);
                                    HookCheck hookCheck = InitBean.checkHook(aClass1);
                                    if (hookCheck != null) {
                                        if (hookCheck.isList()) {
                                            IocUtil.addListBean(hookCheck.getIocName(), newProxyInstance);
                                            continue block5;
                                        }
                                        IocUtil.addBean(hookCheck.getIocName(), newProxyInstance);
                                        continue block5;
                                    }
                                    IocUtil.addBean(aClass1.getName(), newProxyInstance);
                                    continue block5;
                                }
                            }
                            catch (Throwable throwable) {
                            }
                        }
                    }
                } else {
                    Object newProxyInstance;
                    Object bean = IocUtil.getBean(value);
                    if (bean != null) {
                        Class<?> aClass1 = bean.getClass();
                        newProxyInstance = hookProxyFactory.newProxyInstance(aClass1, value.getName() + "HOOK");
                    } else {
                        newProxyInstance = hookProxyFactory.newProxyInstance(value, value.getName() + "HOOK");
                    }
                    if (newProxyInstance != null) {
                        IocUtil.addBean(newProxyInstance.getClass().getName(), newProxyInstance);
                        IocUtil.addBean(value.getName(), newProxyInstance);
                    }
                }
                IocUtil.addListBean(value.getName() + "HOOK", aClass.newInstance());
            }
        }
    }

    public static void injection() {
        Map<String, Object> all = IocUtil.getAll();
        all.forEach((k, v) -> {
            if (v instanceof List) {
                List v1 = (List)v;
                for (Object o : v1) {
                    InitBean.autoZr(o);
                }
            } else {
                InitBean.autoZr(v);
            }
        });
    }

    private static void autoZr(Object v) {
        Class<?> par = v.getClass();
        while (!par.equals(Object.class)) {
            Field[] declaredFields;
            for (Field field : declaredFields = par.getDeclaredFields()) {
                InitBean.valuezr(field, v);
                InitBean.zr(field, v);
            }
            par = par.getSuperclass();
        }
    }

    private static void valuezr(Field declaredField, Object v) {
        Value annotation = declaredField.getAnnotation(Value.class);
        if (annotation != null) {
            try {
                declaredField.setAccessible(true);
                PropUtil instance = PropUtil.getInstance();
                String s = instance.get(annotation.value());
                Object convert = ParameterUtil.convert(declaredField.getType(), s);
                declaredField.set(v, convert);
            }
            catch (Exception e) {
                log.error("{}----->{}\uff1a@Value\u88c5\u914d\u9519\u8bef", (Object)v.getClass().getSimpleName(), (Object)v.getClass().getSimpleName());
            }
        }
    }

    private static void zr(Field declaredField, Object v) {
        Autowired annotation = declaredField.getAnnotation(Autowired.class);
        if (annotation != null) {
            String findMsg;
            Object bean;
            declaredField.setAccessible(true);
            if (annotation.value().trim().length() > 0) {
                bean = IocUtil.getBean(annotation.value());
                findMsg = "\u6309\u81ea\u5b9a\u4e49\u540d\u5b57\u88c5\u914d\uff0c" + declaredField.getType().getSimpleName();
            } else {
                findMsg = "\u6309\u7c7b\u578b\u88c5\u914d\uff0c" + declaredField.getType().getSimpleName();
                bean = IocUtil.getBean(declaredField.getType());
            }
            if (bean == null) {
                Map<String, Object> all = IocUtil.getAll();
                ArrayList allClassByInterface = new ArrayList();
                all.forEach((a, b) -> {
                    if (declaredField.getType().isAssignableFrom(b.getClass())) {
                        allClassByInterface.add(b.getClass());
                    }
                });
                if (allClassByInterface.size() > 0) {
                    if (allClassByInterface.size() > 1) {
                        int tempCode = 0;
                        boolean flag = false;
                        for (Class aClass : allClassByInterface) {
                            Object bean1 = IocUtil.getBean(aClass);
                            if (bean1 == null) continue;
                            if (tempCode == 0) {
                                tempCode = bean1.hashCode();
                                continue;
                            }
                            if (tempCode == bean1.hashCode()) continue;
                            flag = true;
                            break;
                        }
                        if (flag) {
                            log.warn("\u88c5\u914d\u8b66\u544a\uff0c\u5b58\u5728\u591a\u4e2a\u5b50\u7c7b\uff0c\u5efa\u8bae\u901a\u8fc7Bean\u540d\u5b57\u88c5\u914d\uff0c\u907f\u514d\u88c5\u914d\u9519\u8bef");
                        }
                    }
                    bean = IocUtil.getBean((Class)allClassByInterface.get(0));
                    findMsg = "\u6309\u5b50\u7c7b\u88c5\u914d\uff0c" + declaredField.getType().getSimpleName();
                }
            }
            if (bean == null) {
                return;
            }
            try {
                if (bean.getClass().getName().contains(declaredField.getType().getName())) {
                    declaredField.set(v, bean);
                    log.info("{}----->{}\uff1a\u88c5\u914d\u5b8c\u6210\uff0c{}", new Object[]{bean.getClass().getSimpleName(), v.getClass().getSimpleName(), findMsg});
                } else if (declaredField.getType().isAssignableFrom(bean.getClass())) {
                    declaredField.set(v, bean);
                    log.info("{}----->{}\uff1a\u88c5\u914d\u5b8c\u6210\uff0c{}", new Object[]{bean.getClass().getSimpleName(), v.getClass().getSimpleName(), findMsg});
                } else {
                    log.error("{}----->{}\uff1a\u88c5\u914d\u9519\u8bef:\u7c7b\u578b\u4e0d\u5339\u914d", (Object)v.getClass().getSimpleName(), (Object)v.getClass().getSimpleName());
                }
            }
            catch (Exception e) {
                log.error("\u88c5\u914d\u9519\u8bef:{},{}", (Object)declaredField.getName(), (Object)e.getMessage());
            }
        }
    }
}

