/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.ioc.ref;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Loader;
import javassist.LoaderClassPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.HServerApplication;
import top.hserver.core.interfaces.TrackAdapter;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.util.ClassLoadUtil;
import top.hserver.core.server.util.ExceptionUtil;

public class MemoryInitClass {
    private static final Logger log = LoggerFactory.getLogger(MemoryInitClass.class);
    public static final ConcurrentHashMap<String, Object> annMapMethod = new ConcurrentHashMap();
    private static final List<String> cache = new ArrayList<String>();

    public static void modifyNetty() {
        ClassPool cp = ClassPool.getDefault();
        try {
            String strPath = "io.netty.util.concurrent.AbstractEventExecutor";
            LoaderClassPath classPath = new LoaderClassPath(Thread.currentThread().getContextClassLoader());
            cp.insertClassPath((ClassPath)classPath);
            Loader loader = new Loader(cp);
            Class abstractEventExecutor = loader.loadClass(strPath);
            CtClass ctClass = cp.getCtClass(abstractEventExecutor.getName());
            ctClass.freeze();
            ctClass.defrost();
            CtClass executorType = cp.get(Executor.class.getCanonicalName());
            CtField ctField = new CtField(executorType, "executor", ctClass);
            ctField.setModifiers(16);
            ctClass.addField(ctField, "com.alibaba.ttl.threadpool.TtlExecutors.getTtlExecutor(this);");
            CtMethod m = new CtMethod(cp.get(Executor.class.getCanonicalName()), "getTtlExecutor", new CtClass[0], ctClass);
            m.setModifiers(1);
            m.setBody("return this.executor;");
            ctClass.addMethod(m);
            ctClass.toClass();
            ctClass.detach();
        }
        catch (Throwable e) {
            log.error(ExceptionUtil.getMessage(e));
        }
    }

    public static void init(String packageName) {
        block13: {
            if (packageName == null || packageName.startsWith("top.hserver")) {
                return;
            }
            try {
                List<Class<?>> classes = ClassLoadUtil.LoadClasses(packageName, true);
                ClassPool cp = ClassPool.getDefault();
                block6: for (Class<?> aClass : classes) {
                    CtMethod[] methods;
                    for (String trackNoPackage : ConstConfig.TRACK_NO_PACKAGES) {
                        if (!aClass.getName().startsWith(trackNoPackage)) {
                            continue;
                        }
                        break block13;
                    }
                    if (aClass.getName().equals(HServerApplication.mainClass.getName())) continue;
                    CtClass cc = null;
                    try {
                        ClassClassPath classPath = new ClassClassPath(aClass);
                        cp.insertClassPath((ClassPath)classPath);
                        CtClass ctClass = cp.getCtClass(aClass.getName());
                        if (ctClass.isInterface()) continue;
                        CtClass[] interfaces = ctClass.getInterfaces();
                        if (interfaces.length > 0) {
                            for (CtClass anInterface : interfaces) {
                                if (anInterface.getName().equals(TrackAdapter.class.getName())) continue block6;
                            }
                        }
                        methods = ctClass.getDeclaredMethods();
                    }
                    catch (Throwable error) {
                        continue;
                    }
                    if (methods == null || methods.length == 0) continue;
                    for (CtMethod method : methods) {
                        if (cache.contains(aClass.getName())) continue;
                        cache.add(aClass.getName());
                        if (method.isEmpty()) continue;
                        cc = cp.get(aClass.getName());
                        cc.freeze();
                        cc.defrost();
                        log.debug("\u88ab\u94fe\u8def\u8ddf\u8e2a\u7684\u7c7b\uff1a{}", (Object)aClass.getName());
                        MemoryInitClass.initTrack(cc, cp, method);
                    }
                    if (cc == null) continue;
                    try {
                        cc.toClass();
                        cc.detach();
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage());
                    }
                }
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getMessage(e));
            }
        }
    }

    public static void closeCache() {
        cache.clear();
    }

    private static void initTrack(CtClass cc, ClassPool cp, CtMethod method) {
        CtMethod[] methods;
        for (CtMethod declaredMethod : methods = cc.getDeclaredMethods()) {
            String uuid = UUID.randomUUID().toString();
            try {
                cp.insertClassPath((ClassPath)new ClassClassPath(CtMethod.class));
                annMapMethod.put(uuid, declaredMethod);
                log.debug("\u88ab\u94fe\u8def\u8ddf\u8e2a\u7684\u65b9\u6cd5\uff1a{}", (Object)declaredMethod.getName());
                declaredMethod.addLocalVariable("begin_hserver", CtClass.longType);
                declaredMethod.addLocalVariable("end_hserver", CtClass.longType);
                declaredMethod.addLocalVariable("spanId", CtClass.longType);
                declaredMethod.addLocalVariable("trackAdapter_hserver", cp.get(List.class.getCanonicalName()));
                declaredMethod.addLocalVariable("clazz_hserver", cp.get(Class.class.getCanonicalName()));
                declaredMethod.addLocalVariable("annMethodObj", cp.get(CtMethod.class.getCanonicalName()));
                declaredMethod.insertBefore("begin_hserver=System.currentTimeMillis();");
                declaredMethod.insertBefore("spanId=top.hserver.core.server.util.SpanUtil.get();");
                declaredMethod.insertBefore("top.hserver.core.server.util.SpanUtil.add();");
                declaredMethod.insertBefore("annMethodObj = (javassist.CtMethod)top.hserver.core.ioc.ref.MemoryInitClass.annMapMethod.get(\"" + uuid + "\");");
                StringBuilder src = new StringBuilder();
                src.append("end_hserver=System.currentTimeMillis();");
                src.append("trackAdapter_hserver = top.hserver.core.ioc.IocUtil.getListBean(top.hserver.core.interfaces.TrackAdapter.class);");
                src.append("if (trackAdapter_hserver!=null)");
                src.append("{");
                if (!Modifier.isStatic(declaredMethod.getModifiers())) {
                    src.append("clazz_hserver = this.getClass();");
                } else {
                    src.append("clazz_hserver = " + cc.getName() + ".class;");
                }
                src.append("for (int i = 0; i <trackAdapter_hserver.size() ; i++)");
                src.append("{");
                src.append(" ((top.hserver.core.interfaces.TrackAdapter)trackAdapter_hserver.get(i)).track(clazz_hserver,annMethodObj,Thread.currentThread().getStackTrace(), begin_hserver,end_hserver,spanId,spanId+1);");
                src.append("}");
                src.append("}");
                src.append("top.hserver.core.server.util.SpanUtil.clear();");
                declaredMethod.insertAfter(src.toString());
            }
            catch (Exception e) {
                log.warn(method.getName() + "\uff1a" + e.getMessage());
                annMapMethod.remove(uuid);
            }
        }
    }
}

