/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.loader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import top.hserver.core.loader.jar.Handler;
import top.hserver.core.loader.jar.JarFile;

public class LaunchedURLClassLoader
extends URLClassLoader {
    private static LockProvider LOCK_PROVIDER = LaunchedURLClassLoader.setupLockProvider();
    private final ClassLoader rootClassLoader;

    public LaunchedURLClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.rootClassLoader = this.findRootClassLoader(parent);
    }

    private ClassLoader findRootClassLoader(ClassLoader classLoader) {
        while (classLoader != null) {
            if (classLoader.getParent() == null) {
                return classLoader;
            }
            classLoader = classLoader.getParent();
        }
        return null;
    }

    @Override
    public URL getResource(String name) {
        URL url = null;
        if (this.rootClassLoader != null) {
            url = this.rootClassLoader.getResource(name);
        }
        return url == null ? this.findResource(name) : url;
    }

    @Override
    public URL findResource(String name) {
        URL uRL;
        if (name.equals("") && this.hasURLs()) {
            return this.getURLs()[0];
        }
        Handler.setUseFastConnectionExceptions(true);
        try {
            uRL = super.findResource(name);
        }
        catch (Throwable throwable) {
            try {
                Handler.setUseFastConnectionExceptions(false);
                throw throwable;
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        Handler.setUseFastConnectionExceptions(false);
        return uRL;
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        if (name.equals("") && this.hasURLs()) {
            return Collections.enumeration(Arrays.asList(this.getURLs()));
        }
        Handler.setUseFastConnectionExceptions(true);
        try {
            Enumeration<URL> enumeration = super.findResources(name);
            return enumeration;
        }
        finally {
            Handler.setUseFastConnectionExceptions(false);
        }
    }

    private boolean hasURLs() {
        return this.getURLs().length > 0;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.rootClassLoader == null) {
            return this.findResources(name);
        }
        return new ResourceEnumeration(this.rootClassLoader.getResources(name), this.findResources(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = LOCK_PROVIDER.getLock(this, name);
        synchronized (object) {
            Class<?> loadedClass = this.findLoadedClass(name);
            if (loadedClass == null) {
                Handler.setUseFastConnectionExceptions(true);
                try {
                    loadedClass = this.doLoadClass(name);
                }
                finally {
                    Handler.setUseFastConnectionExceptions(false);
                }
            }
            if (resolve) {
                this.resolveClass(loadedClass);
            }
            return loadedClass;
        }
    }

    private Class<?> doLoadClass(String name) throws ClassNotFoundException {
        try {
            if (this.rootClassLoader != null) {
                return this.rootClassLoader.loadClass(name);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.findPackage(name);
            Class<?> cls = this.findClass(name);
            return cls;
        }
        catch (Exception exception) {
            return super.loadClass(name, false);
        }
    }

    private void findPackage(String name) throws ClassNotFoundException {
        String packageName;
        int lastDot = name.lastIndexOf(46);
        if (lastDot != -1 && this.getPackage(packageName = name.substring(0, lastDot)) == null) {
            try {
                this.definePackageForFindClass(name, packageName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void definePackageForFindClass(final String name, final String packageName) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    for (URL url : LaunchedURLClassLoader.this.getURLs()) {
                        try {
                            JarFile jarFile;
                            if (!(url.getContent() instanceof JarFile) || (jarFile = (JarFile)url.getContent()).getJarEntryData(path) == null || jarFile.getManifest() == null) continue;
                            LaunchedURLClassLoader.this.definePackage(packageName, jarFile.getManifest(), url);
                            return null;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return null;
                }
            }, AccessController.getContext());
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }

    private static LockProvider setupLockProvider() {
        try {
            ClassLoader.registerAsParallelCapable();
            return new Java7LockProvider();
        }
        catch (NoSuchMethodError ex) {
            return new LockProvider();
        }
    }

    private static class ResourceEnumeration
    implements Enumeration<URL> {
        private final Enumeration<URL> rootResources;
        private final Enumeration<URL> localResources;

        ResourceEnumeration(Enumeration<URL> rootResources, Enumeration<URL> localResources) {
            this.rootResources = rootResources;
            this.localResources = localResources;
        }

        @Override
        public boolean hasMoreElements() {
            try {
                Handler.setUseFastConnectionExceptions(true);
                boolean bl = this.rootResources.hasMoreElements() || this.localResources.hasMoreElements();
                return bl;
            }
            finally {
                Handler.setUseFastConnectionExceptions(false);
            }
        }

        @Override
        public URL nextElement() {
            if (this.rootResources.hasMoreElements()) {
                return this.rootResources.nextElement();
            }
            return this.localResources.nextElement();
        }
    }

    private static class Java7LockProvider
    extends LockProvider {
        private Java7LockProvider() {
        }

        @Override
        public Object getLock(LaunchedURLClassLoader classLoader, String className) {
            return classLoader.getClassLoadingLock(className);
        }
    }

    private static class LockProvider {
        private LockProvider() {
        }

        public Object getLock(LaunchedURLClassLoader classLoader, String className) {
            return classLoader;
        }
    }
}

