/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.log;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.impl.StaticLoggerBinder;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.PropUtil;

public class HServerLogConfig {
    private static final Logger log = LoggerFactory.getLogger(HServerLogConfig.class);

    private static String[] getStandardConfigLocations() {
        return new String[]{"logback-test.groovy", "logback-test.xml", "logback.groovy", "logback.xml"};
    }

    public static void init() {
        try {
            if (HServerLogConfig.existConfig()) {
                return;
            }
            if (PropUtil.getInstance().get("logbackName").trim().length() > 0) {
                InputStream logbackName = HServerLogConfig.class.getResourceAsStream("/" + PropUtil.getInstance().get("logbackName").trim());
                if (logbackName != null) {
                    HServerLogConfig.loadConfiguration(logbackName);
                    return;
                }
                System.err.println(PropUtil.getInstance().get("logbackName").trim() + "\u6587\u4ef6\u672a\u8bfb\u53d6\u5230\uff0c\u8bf7\u5c06\u6587\u4ef6\u653e\u7f6e\u5728 resources\u76ee\u5f55\u4e0b");
            }
            HServerLogConfig.loadConfiguration(HServerLogConfig.class.getResourceAsStream("/logback-hserver.xml"));
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
    }

    private static boolean existConfig() {
        for (String s : HServerLogConfig.getStandardConfigLocations()) {
            InputStream resourceAsStream = HServerLogConfig.class.getResourceAsStream("/" + s);
            if (resourceAsStream == null) continue;
            try {
                resourceAsStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private static void stopAndReset(LoggerContext loggerContext) {
        loggerContext.stop();
        loggerContext.reset();
    }

    private static void loadConfiguration(InputStream in) throws Exception {
        LoggerContext loggerContext = (LoggerContext)StaticLoggerBinder.getSingleton().getLoggerFactory();
        HServerLogConfig.stopAndReset(loggerContext);
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)loggerContext);
        configurator.doConfigure(in);
        in.close();
        ch.qos.logback.classic.Logger root = loggerContext.getLogger("ROOT");
        if (root != null && PropUtil.getInstance().get("level").trim().length() > 0) {
            root.setLevel(Level.toLevel((String)PropUtil.getInstance().get("level").trim()));
        }
    }
}

