/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.plugs;

import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.PluginAdapter;
import top.hserver.core.server.util.ExceptionUtil;

public class PlugsManager
implements PluginAdapter {
    private static final Logger log = LoggerFactory.getLogger(PlugsManager.class);
    private Set<String> plugPackages = new HashSet<String>();
    private Set<PluginAdapter> obj = new HashSet<PluginAdapter>();

    public PlugsManager() {
        ServiceLoader<PluginAdapter> loadedParsers = ServiceLoader.load(PluginAdapter.class);
        for (PluginAdapter pluginAdapter : loadedParsers) {
            this.obj.add(pluginAdapter);
            this.plugPackages.add(pluginAdapter.getClass().getPackage().getName());
        }
    }

    public Set<String> getPlugPackages() {
        return this.plugPackages;
    }

    public void addPlugins(Class ... plugsClass) {
        for (Class aClass : plugsClass) {
            try {
                this.obj.add((PluginAdapter)aClass.newInstance());
                this.plugPackages.add(aClass.getPackage().getName());
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getMessage(e));
            }
        }
    }

    @Override
    public void startIocInit() {
        for (PluginAdapter plugAdapter : this.obj) {
            plugAdapter.startIocInit();
        }
    }

    @Override
    public void iocInitEnd() {
        for (PluginAdapter plugAdapter : this.obj) {
            plugAdapter.iocInitEnd();
        }
    }

    @Override
    public void startInjection() {
        for (PluginAdapter plugAdapter : this.obj) {
            plugAdapter.startInjection();
        }
    }

    @Override
    public void injectionEnd() {
        for (PluginAdapter plugAdapter : this.obj) {
            plugAdapter.injectionEnd();
        }
    }
}

