/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.properties;

import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.util.PropUtil;
import top.hserver.core.server.util.TTLUtil;

public class PropertiesInit {
    public static void configFile() {
        Integer businessPool;
        String trackNoPackages;
        String trackExtPackages;
        Integer humPort;
        Integer workerPool;
        Integer bossPool;
        PropUtil instance = PropUtil.getInstance();
        Integer taskPool = instance.getInt("taskPool");
        if (taskPool != null) {
            ConstConfig.taskPool = taskPool;
        }
        if ((bossPool = instance.getInt("bossPool")) != null) {
            ConstConfig.bossPool = bossPool;
        }
        if ((workerPool = instance.getInt("workerPool")) != null) {
            ConstConfig.workerPool = workerPool;
        }
        if ((humPort = instance.getInt("humPort")) != null) {
            ConstConfig.HUM_PORT = humPort;
        }
        if ((trackExtPackages = instance.get("trackExtPackages")).trim().length() > 0) {
            ConstConfig.TRACK_EXT_PACKAGES = trackExtPackages.split(",");
        }
        if ((trackNoPackages = instance.get("trackNoPackages")).trim().length() > 0) {
            ConstConfig.TRACK_NO_PACKAGES = trackNoPackages.split(",");
        }
        try {
            String portsStr = instance.get("ports");
            if (portsStr.trim().length() > 0) {
                String[] portStars = portsStr.split(",");
                Integer[] ports = new Integer[portStars.length];
                for (int i = 0; i < portStars.length; ++i) {
                    ports[i] = Integer.parseInt(portStars[i]);
                }
                ConstConfig.PORTS = ports;
            }
        }
        catch (Throwable portsStr) {
            // empty catch block
        }
        if (instance.get("appName").trim().length() > 0) {
            ConstConfig.APP_NAME = instance.get("appName");
        }
        if (instance.get("persistPath").trim().length() > 0) {
            ConstConfig.PERSIST_PATH = instance.get("persistPath");
        }
        if (instance.get("openHttp2").trim().length() > 0) {
            ConstConfig.openHttp2 = Boolean.valueOf(instance.get("openHttp2"));
        }
        if (instance.get("track").trim().length() > 0) {
            ConstConfig.TRACK = Boolean.valueOf(instance.get("track"));
        }
        if (instance.get("readLimit").trim().length() > 0) {
            ConstConfig.READ_LIMIT = Long.valueOf(instance.get("readLimit"));
        }
        if (instance.get("writeLimit").trim().length() > 0) {
            ConstConfig.WRITE_LIMIT = Long.valueOf(instance.get("writeLimit"));
        }
        if (instance.get("httpContentSize").trim().length() > 0) {
            ConstConfig.HTTP_CONTENT_SIZE = instance.getInt("httpContentSize");
        }
        if ((businessPool = instance.getInt("businessPool")) != null && businessPool > 0) {
            ConstConfig.BUSINESS_EVENT = TTLUtil.getEventLoop(businessPool, "hserver_business");
        }
        ConstConfig.BUSINESS_EVENT = businessPool != null && businessPool < 0 ? null : TTLUtil.getEventLoop(50, "hserver_business");
    }
}

