/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import top.hserver.core.interfaces.HookAdapter;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.ioc.annotation.Hook;

public class HookProxyFactory {
    public Object newProxyInstance(Class clazz, String hookPageName) throws InstantiationException, IllegalAccessException {
        ProxyFactory proxyFactory = new ProxyFactory();
        if (ProxyObject.class.isAssignableFrom(clazz)) {
            return null;
        }
        proxyFactory.setSuperclass(clazz);
        Object o = proxyFactory.createClass().newInstance();
        ((ProxyObject)o).setHandler((self, thismethod, proceed, args) -> {
            Method[] declaredMethods;
            for (Method declaredMethod : declaredMethods = clazz.getDeclaredMethods()) {
                if (!declaredMethod.getName().equals(thismethod.getName())) continue;
                List<Object> listBean = IocUtil.getListBean(hookPageName);
                for (HookAdapter hookAdapter : listBean) {
                    if (!this.check(hookAdapter, self.getClass(), thismethod)) continue;
                    hookAdapter.before(self.getClass(), thismethod, args);
                }
                try {
                    proceed.setAccessible(true);
                    Object result = proceed.invoke(self, args);
                    for (HookAdapter hookAdapter : listBean) {
                        if (!this.check(hookAdapter, self.getClass(), thismethod)) continue;
                        result = hookAdapter.after(self.getClass(), thismethod, result);
                    }
                    return result;
                }
                catch (Throwable e) {
                    for (HookAdapter hookAdapter : listBean) {
                        if (!this.check(hookAdapter, self.getClass(), thismethod)) continue;
                        if (e instanceof InvocationTargetException) {
                            e = ((InvocationTargetException)e).getTargetException();
                        }
                        hookAdapter.throwable(self.getClass(), thismethod, e);
                    }
                    if (e instanceof InvocationTargetException) {
                        throw ((InvocationTargetException)e).getTargetException();
                    }
                    throw e;
                }
            }
            proceed.setAccessible(true);
            return proceed.invoke(self, args);
        });
        return o;
    }

    private boolean check(HookAdapter hookAdapter, Class self, Method method) {
        Hook hook = hookAdapter.getClass().getAnnotation(Hook.class);
        for (Class aClass : hook.value()) {
            Annotation[] annotations2;
            Annotation[] annotations1;
            Class superclass = self.getSuperclass();
            if (aClass == superclass) {
                return true;
            }
            for (Annotation annotation : annotations1 = self.getSuperclass().getAnnotations()) {
                if (annotation.annotationType() != aClass) continue;
                return true;
            }
            for (Annotation annotation : annotations2 = method.getAnnotations()) {
                if (annotation.annotationType() != aClass) continue;
                return true;
            }
        }
        return false;
    }
}

