/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.queue;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.ioc.annotation.queue.QueueHandler;
import top.hserver.core.ioc.annotation.queue.QueueListener;
import top.hserver.core.ioc.ref.PackageScanner;
import top.hserver.core.queue.QueueData;
import top.hserver.core.queue.QueueFactoryImpl;
import top.hserver.core.queue.QueueHandleInfo;
import top.hserver.core.queue.QueueHandleMethod;
import top.hserver.core.queue.QueueInfo;
import top.hserver.core.queue.fqueue.FQueue;
import top.hserver.core.queue.fqueue.exception.FileFormatException;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.NamedThreadFactory;
import top.hserver.core.server.util.SerializationUtil;

public class QueueDispatcher {
    private static final Logger log = LoggerFactory.getLogger(QueueDispatcher.class);
    private static Map<String, QueueHandleInfo> handleMethodMap = new ConcurrentHashMap<String, QueueHandleInfo>();
    private static Map<String, FQueue> FQ = new ConcurrentHashMap<String, FQueue>();
    private static final int buffSize = 1024;

    private QueueDispatcher() {
    }

    public static void removeQueue(String queueName, boolean trueDelete) {
        QueueHandleInfo queueHandleInfo = handleMethodMap.get(queueName);
        if (queueHandleInfo != null && queueHandleInfo.getQueueFactory() != null) {
            queueHandleInfo.getQueueFactory().stop();
        }
        handleMethodMap.remove(queueName);
        FQueue fQueue = FQ.get(queueName);
        if (fQueue != null) {
            if (trueDelete) {
                fQueue.clear();
            }
            try {
                fQueue.close();
            }
            catch (IOException | FileFormatException e) {
                log.error(ExceptionUtil.getMessage(e));
            }
        }
        FQ.remove(queueName);
    }

    public static List<String> getAllQueueName() {
        return new ArrayList<String>(FQ.keySet());
    }

    public static void addQueueListener(String queueName, Class clazz) {
        Method[] methods;
        Object obj = IocUtil.getBean(clazz);
        if (obj == null) {
            log.error("{} \u5bb9\u5668\u4e2d\u4e0d\u5b58\u5728", (Object)clazz.getName());
            return;
        }
        QueueListener queueListener = obj.getClass().getAnnotation(QueueListener.class);
        if (queueListener == null) {
            log.error("{} \u5b83\u4e0d\u662f\u4e00\u4e2a\u6d88\u606f\u76d1\u542c\u5668", (Object)clazz.getName());
            return;
        }
        IocUtil.addBean(queueName, obj);
        QueueHandleInfo eventHandleInfo = new QueueHandleInfo();
        eventHandleInfo.setQueueHandlerType(queueListener.type());
        eventHandleInfo.setQueueName(queueName);
        eventHandleInfo.setBufferSize(1024);
        for (Method method : methods = clazz.getDeclaredMethods()) {
            QueueHandler queueHandler = method.getAnnotation(QueueHandler.class);
            if (queueHandler == null) continue;
            if (queueHandler.size() > eventHandleInfo.getThreadSize()) {
                eventHandleInfo.setThreadSize(queueHandler.size());
            }
            eventHandleInfo.add(new QueueHandleMethod(method, queueHandler.level(), queueHandler.size()));
            log.debug("\u5bfb\u627e\u961f\u5217 [{}] \u7684\u65b9\u6cd5 [{}.{}]", new Object[]{queueName, clazz.getSimpleName(), method.getName()});
        }
        handleMethodMap.put(queueName, eventHandleInfo);
        QueueDispatcher.initConfigQueue(eventHandleInfo);
    }

    public static void init(PackageScanner scanner) throws IOException {
        Set<Class<?>> classes = scanner.getAnnotationList(QueueListener.class);
        for (Class<?> clazz : classes) {
            Method[] methods;
            Object obj;
            QueueListener queueListener = clazz.getAnnotation(QueueListener.class);
            if (queueListener == null) continue;
            try {
                obj = clazz.newInstance();
            }
            catch (Exception e) {
                log.error("initialize " + clazz.getSimpleName() + " error", (Throwable)e);
                continue;
            }
            if (queueListener.queueName().trim().length() == 0) {
                IocUtil.addBean(obj);
                continue;
            }
            IocUtil.addBean(queueListener.queueName(), obj);
            QueueHandleInfo eventHandleInfo = new QueueHandleInfo();
            eventHandleInfo.setQueueHandlerType(queueListener.type());
            eventHandleInfo.setQueueName(queueListener.queueName());
            eventHandleInfo.setBufferSize(1024);
            for (Method method : methods = clazz.getDeclaredMethods()) {
                QueueHandler queueHandler = method.getAnnotation(QueueHandler.class);
                if (queueHandler == null) continue;
                if (queueHandler.size() > eventHandleInfo.getThreadSize()) {
                    eventHandleInfo.setThreadSize(queueHandler.size());
                }
                eventHandleInfo.add(new QueueHandleMethod(method, queueHandler.level(), queueHandler.size()));
                log.debug("\u5bfb\u627e\u961f\u5217 [{}] \u7684\u65b9\u6cd5 [{}.{}]", new Object[]{queueListener.queueName(), clazz.getSimpleName(), method.getName()});
            }
            handleMethodMap.put(queueListener.queueName(), eventHandleInfo);
        }
    }

    private static void initConfigQueue(QueueHandleInfo v) {
        try {
            FQueue fQueue = new FQueue(ConstConfig.PERSIST_PATH + File.separator + v.getQueueName());
            FQ.put(v.getQueueName(), fQueue);
        }
        catch (Exception fQueue) {
            // empty catch block
        }
        QueueFactoryImpl queueFactory = new QueueFactoryImpl();
        queueFactory.createQueue(v.getQueueName(), v.getBufferSize(), v.getQueueHandlerType(), v.getQueueHandleMethods());
        v.setQueueFactory(queueFactory);
        v.getQueueFactory().start();
    }

    public static void startTaskThread() {
        handleMethodMap.forEach((k, v) -> {
            if (v.getQueueFactory() != null) {
                v.getQueueFactory().stop();
            }
        });
        FQ.forEach((k, v) -> {
            try {
                v.close();
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getMessage(e));
            }
        });
        FQ.clear();
        handleMethodMap.forEach((k, v) -> QueueDispatcher.initConfigQueue(v));
        Thread thread = new NamedThreadFactory("hserver_queue").newThread(() -> {
            while (true) {
                if (FQ.size() > 0) {
                    FQ.forEach((k, v) -> {
                        try {
                            QueueInfo queueInfo = QueueDispatcher.queueInfo(k);
                            QueueHandleInfo queueHandleInfo = handleMethodMap.get(k);
                            if (queueHandleInfo == null) {
                                QueueDispatcher.sleep();
                                return;
                            }
                            int threadSize = queueHandleInfo.getThreadSize();
                            if (queueInfo != null && queueInfo.getBufferSize() - queueInfo.getRemainQueueSize() < (long)threadSize) {
                                byte[] poll = threadSize == 1 ? v.peek() : v.poll();
                                if (poll != null) {
                                    QueueData deserialize = SerializationUtil.deserialize(poll, QueueData.class);
                                    QueueDispatcher.dispatcherQueue(deserialize, deserialize.getQueueName());
                                } else {
                                    QueueDispatcher.sleep();
                                }
                            } else {
                                QueueDispatcher.sleep();
                            }
                        }
                        catch (Exception e) {
                            QueueDispatcher.sleep();
                            log.error(ExceptionUtil.getMessage(e));
                        }
                    });
                    continue;
                }
                QueueDispatcher.sleep();
            }
        });
        thread.start();
    }

    private static boolean dispatcherQueue(QueueData queueData, String queueName) {
        QueueHandleInfo queueHandleInfo = handleMethodMap.get(queueName);
        if (queueHandleInfo != null) {
            if (queueData != null) {
                queueData.setfQueue(FQ.get(queueName));
                queueData.setThreadSize(queueHandleInfo.getThreadSize());
                queueHandleInfo.getQueueFactory().producer(queueData);
            }
            return true;
        }
        log.error("\u4e0d\u5b58\u5728:{} \u961f\u5217", (Object)queueName);
        return false;
    }

    public static boolean dispatcherSerializationQueue(String queueName, Object ... args) {
        FQueue fQueue = FQ.get(queueName);
        if (fQueue == null) {
            log.error("\u4e0d\u5b58\u5728:{} \u961f\u5217", (Object)queueName);
            return false;
        }
        fQueue.offer(SerializationUtil.serialize(new QueueData(queueName, args, null)));
        return true;
    }

    public static QueueInfo queueInfo(String queueName) {
        QueueHandleInfo queueHandleInfo = handleMethodMap.get(queueName);
        if (queueHandleInfo != null && queueHandleInfo.getQueueFactory() != null) {
            QueueInfo queueInfo = queueHandleInfo.getQueueFactory().queueInfo();
            return queueInfo;
        }
        return null;
    }

    private static void sleep() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            log.error(ExceptionUtil.getMessage(e));
        }
    }
}

