/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.queue.fqueue;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import top.hserver.core.queue.fqueue.FSQueue;
import top.hserver.core.queue.fqueue.exception.FileFormatException;

public class FQueue
extends AbstractQueue<byte[]>
implements Serializable {
    private static final long serialVersionUID = -1L;
    private FSQueue fsQueue = null;
    private Lock lock = new ReentrantReadWriteLock().writeLock();

    public FQueue(String path) throws IOException, FileFormatException {
        this.fsQueue = new FSQueue(path);
    }

    public FQueue(String path, int entityLimitLength) throws IOException, FileFormatException {
        this.fsQueue = new FSQueue(path, entityLimitLength);
    }

    public FQueue(File dir) throws IOException, FileFormatException {
        this.fsQueue = new FSQueue(dir);
    }

    public FQueue(File dir, int entityLimitLength) throws IOException, FileFormatException {
        this.fsQueue = new FSQueue(dir, entityLimitLength);
    }

    @Override
    public Iterator<byte[]> iterator() {
        throw new UnsupportedOperationException("iterator Unsupported now");
    }

    @Override
    public int size() {
        return this.fsQueue.getQueueSize();
    }

    @Override
    public boolean offer(byte[] e) {
        try {
            this.lock.lock();
            this.fsQueue.add(e);
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (FileFormatException fileFormatException) {
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    @Override
    public byte[] peek() {
        try {
            this.lock.lock();
            byte[] byArray = this.fsQueue.readNext();
            return byArray;
        }
        catch (IOException ex) {
            byte[] byArray = null;
            return byArray;
        }
        catch (FileFormatException ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] poll() {
        try {
            this.lock.lock();
            byte[] byArray = this.fsQueue.readNextAndRemove();
            return byArray;
        }
        catch (IOException ex) {
            byte[] byArray = null;
            return byArray;
        }
        catch (FileFormatException ex) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clear() {
        try {
            this.lock.lock();
            this.fsQueue.clear();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (FileFormatException fileFormatException) {
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws IOException, FileFormatException {
        if (this.fsQueue != null) {
            this.fsQueue.close();
        }
    }
}

