/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.queue.fqueue.internal;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicInteger;
import top.hserver.core.queue.fqueue.exception.FileFormatException;
import top.hserver.core.queue.fqueue.internal.Entity;

public class Index {
    private static final int INDEX_LIMIT_LENGTH = 32;
    private static final String INDEX_FILE_NAME = "fq.idx";
    private RandomAccessFile dbRandFile = null;
    private FileChannel fc;
    private MappedByteBuffer mappedByteBuffer;
    private String magicString = null;
    private int version = -1;
    private int readerPosition = -1;
    private int writerPosition = -1;
    private int readerIndex = -1;
    private int writerIndex = -1;
    private AtomicInteger size = new AtomicInteger();

    public Index(String path) throws IOException, FileFormatException {
        File dbFile = new File(path, INDEX_FILE_NAME);
        if (!dbFile.exists()) {
            dbFile.createNewFile();
            this.dbRandFile = new RandomAccessFile(dbFile, "rwd");
            this.initIdxFile();
        } else {
            this.dbRandFile = new RandomAccessFile(dbFile, "rwd");
            if (this.dbRandFile.length() < 32L) {
                throw new FileFormatException("file format error.");
            }
            byte[] bytes = new byte[32];
            this.dbRandFile.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            bytes = new byte["FQueuefs".getBytes().length];
            buffer.get(bytes);
            this.magicString = new String(bytes);
            this.version = buffer.getInt();
            this.readerPosition = buffer.getInt();
            this.writerPosition = buffer.getInt();
            this.readerIndex = buffer.getInt();
            this.writerIndex = buffer.getInt();
            int sz = buffer.getInt();
            if (this.readerPosition == this.writerPosition && this.readerIndex == this.writerIndex && sz <= 0) {
                this.initIdxFile();
            } else {
                this.size.set(sz);
            }
        }
        this.fc = this.dbRandFile.getChannel();
        this.mappedByteBuffer = this.fc.map(FileChannel.MapMode.READ_WRITE, 0L, 32L);
    }

    private void initIdxFile() throws IOException {
        this.magicString = "FQueuefs";
        this.version = 1;
        this.readerPosition = Entity.MESSAGE_START_POSITION;
        this.writerPosition = Entity.MESSAGE_START_POSITION;
        this.readerIndex = 1;
        this.writerIndex = 1;
        this.dbRandFile.setLength(32L);
        this.dbRandFile.seek(0L);
        this.dbRandFile.write(this.magicString.getBytes());
        this.dbRandFile.writeInt(this.version);
        this.dbRandFile.writeInt(this.readerPosition);
        this.dbRandFile.writeInt(this.writerPosition);
        this.dbRandFile.writeInt(this.readerIndex);
        this.dbRandFile.writeInt(this.writerIndex);
        this.dbRandFile.writeInt(0);
    }

    public void clear() throws IOException {
        this.mappedByteBuffer.clear();
        this.mappedByteBuffer.force();
        this.initIdxFile();
    }

    public void putWriterPosition(int pos) {
        this.mappedByteBuffer.position(16);
        this.mappedByteBuffer.putInt(pos);
        this.writerPosition = pos;
    }

    public void putReaderPosition(int pos) {
        this.mappedByteBuffer.position(12);
        this.mappedByteBuffer.putInt(pos);
        this.readerPosition = pos;
    }

    public void putWriterIndex(int index) {
        this.mappedByteBuffer.position(24);
        this.mappedByteBuffer.putInt(index);
        this.writerIndex = index;
    }

    public void putReaderIndex(int index) {
        this.mappedByteBuffer.position(20);
        this.mappedByteBuffer.putInt(index);
        this.readerIndex = index;
    }

    public void incrementSize() {
        int num = this.size.incrementAndGet();
        this.mappedByteBuffer.position(28);
        this.mappedByteBuffer.putInt(num);
    }

    public void decrementSize() {
        int num = this.size.decrementAndGet();
        this.mappedByteBuffer.position(28);
        this.mappedByteBuffer.putInt(num);
    }

    public String getMagicString() {
        return this.magicString;
    }

    public int getVersion() {
        return this.version;
    }

    public int getReaderPosition() {
        return this.readerPosition;
    }

    public int getWriterPosition() {
        return this.writerPosition;
    }

    public int getReaderIndex() {
        return this.readerIndex;
    }

    public int getWriterIndex() {
        return this.writerIndex;
    }

    public int getSize() {
        return this.size.get();
    }

    public void close() throws IOException {
        this.mappedByteBuffer.force();
        this.mappedByteBuffer.clear();
        this.fc.close();
        this.dbRandFile.close();
        this.mappedByteBuffer = null;
        this.fc = null;
        this.dbRandFile = null;
    }

    public String headerInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append(" magicString:");
        sb.append(this.magicString);
        sb.append(" version:");
        sb.append(this.version);
        sb.append(" readerPosition:");
        sb.append(this.readerPosition);
        sb.append(" writerPosition:");
        sb.append(this.writerPosition);
        sb.append(" size:");
        sb.append(this.size);
        sb.append(" readerIndex:");
        sb.append(this.readerIndex);
        sb.append(" writerIndex:");
        sb.append(this.writerIndex);
        return sb.toString();
    }
}

