/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.InitRunner;
import top.hserver.core.interfaces.ServerCloseAdapter;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.queue.QueueDispatcher;
import top.hserver.core.server.HumClient;
import top.hserver.core.server.ServerInitializer;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.HumMessage;
import top.hserver.core.server.handlers.HumClientHandler;
import top.hserver.core.server.handlers.HumServerHandler;
import top.hserver.core.server.util.EpollUtil;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.IpUtil;
import top.hserver.core.server.util.NamedThreadFactory;
import top.hserver.core.server.util.SslContextUtil;
import top.hserver.core.server.util.TTLUtil;
import top.hserver.core.task.TaskManager;

public class HServer {
    private static final Logger log = LoggerFactory.getLogger(HServer.class);
    private final Integer[] ports;
    private final String[] args;
    private final Map<Channel, String> channels = new HashMap<Channel, String>();
    private EventLoopGroup humServerBossGroup = null;
    private EventLoopGroup humClientBossGroup = null;
    private EventLoopGroup bossGroup = null;
    private EventLoopGroup workerGroup = null;

    public HServer(Integer[] ports, String[] args) {
        this.ports = ports;
        this.args = args;
    }

    public void run() throws Exception {
        String typeName;
        this.humServerBossGroup = new NioEventLoopGroup();
        Bootstrap humServer = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)humServer.group(this.humServerBossGroup)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)true)).handler((ChannelHandler)new HumServerHandler());
        Channel humChannel = humServer.bind(ConstConfig.HUM_PORT.intValue()).sync().channel();
        this.channels.put(humChannel, "UDP Server Port:" + ConstConfig.HUM_PORT);
        this.humClientBossGroup = new NioEventLoopGroup();
        Bootstrap humClient = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)humClient.group(this.humClientBossGroup)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new HumClientHandler());
        HumClient.channel = humClient.bind(0).sync().channel();
        this.channels.put(HumClient.channel, "UDP Client Port:0");
        ServerBootstrap bootstrap = new ServerBootstrap();
        if (EpollUtil.check()) {
            bootstrap.option(EpollChannelOption.SO_REUSEPORT, (Object)true);
            bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
            this.bossGroup = TTLUtil.getEventLoop(ConstConfig.bossPool, "hserver_epoll_boss");
            this.workerGroup = TTLUtil.getEventLoop(ConstConfig.workerPool, "hserver_epoll_worker");
            bootstrap.group(this.bossGroup, this.workerGroup).channel(EpollServerSocketChannel.class);
            typeName = "Epoll";
        } else {
            bootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
            bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
            this.bossGroup = TTLUtil.getEventLoop(ConstConfig.bossPool, "hserver_boss");
            this.workerGroup = TTLUtil.getEventLoop(ConstConfig.workerPool, "hserver_worker");
            bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class);
            typeName = "Nio";
        }
        SslContextUtil.setSsl();
        bootstrap.childHandler((ChannelHandler)new ServerInitializer());
        String portStr = "";
        for (Integer port : this.ports) {
            portStr = portStr + port + " ";
            Channel channel = bootstrap.bind(port.intValue()).sync().channel();
            this.channels.put(channel, "TCP Server Port:" + port);
        }
        log.info("HServer \u542f\u52a8\u5b8c\u6210");
        System.out.println();
        System.out.println(this.getHello(typeName, portStr));
        System.out.println();
        this.shutdownHook();
        this.initOk();
    }

    private void shutdownHook() {
        this.publishMessage(ConstConfig.APP_NAME + "\u4e0a\u7ebf\uff0cIP\uff1a" + IpUtil.getLocalIP());
        this.channels.forEach((k, v) -> new NamedThreadFactory("hserver_close").newThread(() -> {
            try {
                k.closeFuture().sync();
                log.info("channel\u5173\u95ed,\u63cf\u8ff0\u4fe1\u606f\uff1a{}", v);
            }
            catch (InterruptedException e) {
                log.error(ExceptionUtil.getMessage(e));
            }
        }).start());
        Thread shutdown = new NamedThreadFactory("hserver_shutdown").newThread(() -> {
            log.info("\u670d\u52a1\u5373\u5c06\u5173\u95ed");
            this.publishMessage(ConstConfig.APP_NAME + "\u4e0b\u7ebf\uff0cIP\uff1a" + IpUtil.getLocalIP());
            List<ServerCloseAdapter> listBean = IocUtil.getListBean(ServerCloseAdapter.class);
            if (listBean != null) {
                for (ServerCloseAdapter serverCloseAdapter : listBean) {
                    serverCloseAdapter.close();
                }
            }
            if (this.humClientBossGroup != null) {
                this.humClientBossGroup.shutdownGracefully();
            }
            if (this.humServerBossGroup != null) {
                this.humServerBossGroup.shutdownGracefully();
            }
            if (this.bossGroup != null) {
                this.bossGroup.shutdownGracefully();
            }
            if (this.workerGroup != null) {
                this.workerGroup.shutdownGracefully();
            }
            log.info("\u670d\u52a1\u5173\u95ed\u5b8c\u6210");
        });
        Runtime.getRuntime().addShutdownHook(shutdown);
    }

    private void initOk() {
        TaskManager.IS_OK = true;
        QueueDispatcher.startTaskThread();
        List<InitRunner> listBean = IocUtil.getListBean(InitRunner.class);
        if (listBean != null) {
            for (InitRunner initRunner : listBean) {
                initRunner.init(this.args);
            }
        }
    }

    private String getHello(String typeName, String port) {
        InputStream banner = HServer.class.getResourceAsStream("/banner.txt");
        try {
            if (banner != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(banner);
                String result = new BufferedReader(inputStreamReader).lines().collect(Collectors.joining(System.lineSeparator()));
                inputStreamReader.close();
                banner.close();
                return result;
            }
        }
        catch (IOException e) {
            log.error("banner.txt \u6d41\u5173\u95ed\u9519\u8bef{}", (Object)e.getMessage());
        }
        return "  ___ ___  _________ \t\u8fd0\u884c\u65b9\u5f0f\uff1a" + typeName + "\t\u7aef\u53e3\uff1a" + port + "\n /   |   \\/   _____/ ______________  __ ___________ \n/    ~    \\_____  \\_/ __ \\_  __ \\  \\/ // __ \\_  __ \\\n\\    Y    /        \\  ___/|  | \\/\\   /\\  ___/|  | \\/\n \\___|_  /_______  /\\___  >__|    \\_/  \\___  >__|   \n       \\/        \\/     \\/                 \\/       ";
    }

    public void publishMessage(String message) {
        HumMessage humMessage = new HumMessage();
        humMessage.setData(message);
        humMessage.setType("HServer");
        HumClient.sendMessage(humMessage);
    }
}

