/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import top.hserver.core.interfaces.ProtocolDispatcherAdapter;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.server.util.ByteBufUtil;

public class ServerInitializer
extends ChannelInitializer<Channel> {
    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{new ProtocolDispatcher()});
    }

    public static class ProtocolDispatcher
    extends ByteToMessageDecoder {
        public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() < 5) {
                return;
            }
            ByteBuf slice = in.slice(0, Math.min(in.readableBytes(), 512));
            byte[] bytes = ByteBufUtil.byteBufToBytes(slice);
            ChannelPipeline pipeline = ctx.pipeline();
            List<ProtocolDispatcherAdapter> listBean = IocUtil.getListBean(ProtocolDispatcherAdapter.class);
            if (listBean == null) {
                return;
            }
            for (ProtocolDispatcherAdapter protocolDispatcherAdapter : listBean) {
                if (!protocolDispatcherAdapter.dispatcher(ctx, pipeline, bytes)) continue;
                ctx.pipeline().remove((ChannelHandler)this);
                ctx.fireChannelActive();
                return;
            }
        }
    }
}

